/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.components;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.PageContext;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlCancelButton;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlHiddenField;
import pt.ist.fenixWebFramework.renderers.components.HtmlSubmitButton;
import pt.ist.fenixWebFramework.renderers.components.controllers.Controllable;
import pt.ist.fenixWebFramework.renderers.components.controllers.HtmlController;
import pt.ist.fenixWebFramework.renderers.components.tags.HtmlTag;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class HtmlForm
extends HtmlComponent
implements Controllable {
    public static final String POST = "post";
    public static final String GET = "get";
    public static final String URL_ENCODED = "application/x-www-form-urlencoded";
    public static final String FORM_DATA = "multipart/form-data";
    private String action;
    private String method;
    private String encoding;
    private HtmlComponent body;
    private final List<HtmlHiddenField> hiddenFields = new ArrayList<HtmlHiddenField>();
    private HtmlSubmitButton submitButton;
    private HtmlCancelButton cancelButton;
    private HtmlController controller;

    public HtmlForm() {
        this.setSubmitButton(new HtmlSubmitButton(RenderUtils.getResourceString("renderers.form.submit.name")));
        this.setCancelButton(new HtmlCancelButton(RenderUtils.getResourceString("renderers.form.cancel.name")));
        this.setEncoding(URL_ENCODED);
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public HtmlComponent getBody() {
        return this.body;
    }

    public void setBody(HtmlComponent component) {
        this.body = component;
    }

    public List<HtmlHiddenField> getHiddenFields() {
        return this.hiddenFields;
    }

    public void addHiddenField(HtmlHiddenField htmlHiddenField) {
        this.hiddenFields.add(htmlHiddenField);
    }

    public HtmlCancelButton getCancelButton() {
        return this.cancelButton;
    }

    public void setCancelButton(HtmlCancelButton cancelButton) {
        this.cancelButton = cancelButton;
        this.configureButton(this.cancelButton);
    }

    public HtmlSubmitButton getSubmitButton() {
        return this.submitButton;
    }

    public void setSubmitButton(HtmlSubmitButton submitButton) {
        this.submitButton = submitButton;
        this.configureButton(this.submitButton);
    }

    protected void configureButton(HtmlSubmitButton button) {
        if (button != null) {
            button.setClasses("inputbutton");
        }
    }

    @Override
    public List<HtmlComponent> getChildren() {
        List<HtmlComponent> children = super.getChildren();
        children.addAll(this.getHiddenFields());
        if (this.body != null) {
            children.add(this.body);
        }
        if (this.submitButton != null) {
            children.add(this.submitButton);
        }
        if (this.cancelButton != null) {
            children.add(this.cancelButton);
        }
        return children;
    }

    @Override
    public HtmlTag getOwnTag(PageContext context) {
        this.addClass("form-horizontal");
        HtmlTag tag = super.getOwnTag(context);
        tag.setName("form");
        tag.setAttribute("role", "form");
        tag.setAttribute("action", this.action);
        tag.setAttribute("method", this.method);
        tag.setAttribute("enctype", this.encoding);
        for (HtmlHiddenField field : this.hiddenFields) {
            tag.addChild(field.getOwnTag(context));
        }
        if (this.body != null) {
            tag.addChild(this.body.getOwnTag(context));
        }
        HtmlBlockContainer formGroup = new HtmlBlockContainer();
        formGroup.setClasses("form-group");
        HtmlBlockContainer buttonContainer = new HtmlBlockContainer();
        formGroup.addChild(buttonContainer);
        buttonContainer.setClasses("col-sm-offset-2 col-sm-10");
        if (this.submitButton != null) {
            buttonContainer.addChild(this.submitButton);
        }
        if (this.cancelButton != null) {
            buttonContainer.addChild(this.cancelButton);
        }
        tag.addChild(formGroup.getOwnTag(context));
        return tag;
    }

    @Override
    public boolean hasController() {
        return this.controller != null;
    }

    @Override
    public HtmlController getController() {
        return this.controller;
    }

    @Override
    public void setController(HtmlController controller) {
        this.controller = controller;
        this.controller.setControlledComponent(this);
    }
}

