/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.ajax;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import pt.ist.fenixWebFramework.renderers.CollectionRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlLink;
import pt.ist.fenixWebFramework.renderers.components.HtmlScript;
import pt.ist.fenixWebFramework.renderers.components.HtmlTable;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableCell;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableHeader;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableRow;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.servlets.filters.contentRewrite.GenericChecksumRewriter;

public class AjaxTableRenderer
extends CollectionRenderer {
    private String ajaxSourceUrl;
    private final Map<String, String> extraParameter = new HashMap<String, String>();

    @Override
    protected Layout getLayout(Object object, Class type) {
        List sortedCollection = RenderUtils.sortCollectionWithCriteria((Collection)object, this.getSortBy());
        return new AjaxTabularLayout(sortedCollection);
    }

    public String getAjaxSourceUrl() {
        return this.ajaxSourceUrl;
    }

    public void setAjaxSourceUrl(String value) {
        this.ajaxSourceUrl = value;
    }

    public String getAjaxSourceUrlWithChecksum() {
        HtmlLink link = new HtmlLink();
        link.setUrl(this.getAjaxSourceUrl());
        link.setModuleRelative(false);
        link.setContextRelative(true);
        String urlParametersBoundaryCharacter = "&";
        if (link.calculateUrl().indexOf("?") == -1) {
            urlParametersBoundaryCharacter = "?";
        }
        return link.calculateUrl() + String.format(urlParametersBoundaryCharacter + "%s=%s", "_request_checksum_", GenericChecksumRewriter.calculateChecksum(link.calculateUrl(), this.getContext().getViewState().getRequest().getSession(false)));
    }

    public Map<String, String> getExtraParameter() {
        return this.extraParameter;
    }

    public void setExtraParameter(String key, String value) {
        this.extraParameter.put(key, value);
    }

    @Override
    public void setCounter(String name, String value) {
    }

    @Override
    public String getCounter(String name) {
        return null;
    }

    public class AjaxTabularLayout
    extends CollectionRenderer.CollectionTabularLayout {
        public AjaxTabularLayout(Collection object) {
            super(AjaxTableRenderer.this, object);
        }

        @Override
        public HtmlComponent createComponent(Object object, Class type) {
            HtmlInlineContainer container = new HtmlInlineContainer();
            this.addAjaxDataTableScript(container);
            int columnNumber = this.getNumberOfColumns();
            this.initializeAjaxDataTable(container, columnNumber);
            HtmlTable table = new HtmlTable();
            container.addChild(table);
            this.setTable(table);
            if (this.hasHeader()) {
                HtmlTableHeader header = table.createHeader();
                HtmlTableRow firstRow = header.createRow();
                HtmlTableRow secondRow = null;
                if (this.hasHeaderGroups()) {
                    secondRow = header.createRow();
                }
                String lastGroup = null;
                HtmlTableCell lastGroupCell = null;
                for (int columnIndex = 0; columnIndex < columnNumber; ++columnIndex) {
                    HtmlTableCell cell;
                    String group = this.getHeaderGroup(columnIndex);
                    if (this.hasHeaderGroups() && group != null) {
                        if (lastGroup != null && lastGroup.equals(group)) {
                            if (lastGroupCell.getColspan() == null) {
                                lastGroupCell.setColspan(2);
                            } else {
                                lastGroupCell.setColspan(lastGroupCell.getColspan() + 1);
                            }
                        } else {
                            cell = firstRow.createCell();
                            cell.setBody(new HtmlText(group));
                            lastGroup = group;
                            lastGroupCell = cell;
                        }
                        cell = secondRow.createCell();
                        cell.setBody(this.getHeaderComponent(columnIndex));
                        continue;
                    }
                    lastGroup = null;
                    lastGroupCell = null;
                    cell = firstRow.createCell();
                    cell.setBody(this.getHeaderComponent(columnIndex));
                    if (!this.hasHeaderGroups()) continue;
                    cell.setRowspan(2);
                }
            }
            return container;
        }

        private void initializeAjaxDataTable(HtmlInlineContainer container, int columnNumber) {
            int i;
            HtmlScript script = new HtmlScript();
            Object scriptValue = "\n";
            scriptValue = (String)scriptValue + "var oTable;\n";
            scriptValue = (String)scriptValue + "$(document).ready(function() {\n";
            scriptValue = (String)scriptValue + "\toTable = $(\".ajax-table\").dataTable({\n";
            scriptValue = (String)scriptValue + this.getAjaxTableLanguageConfiguration() + ",\n";
            scriptValue = (String)scriptValue + "'bProcessing': true,\n";
            scriptValue = (String)scriptValue + "'bServerSide': true,\n";
            scriptValue = (String)scriptValue + "'aaSorting': [[1,'desc']],\n";
            scriptValue = (String)scriptValue + "'iDisplayLength': 100,\n";
            scriptValue = (String)scriptValue + "'sAjaxSource': \"" + AjaxTableRenderer.this.getAjaxSourceUrlWithChecksum() + "\",\n";
            scriptValue = (String)scriptValue + "'fnServerData': function(sSource, aoData, fnCallback){\n";
            for (Map.Entry<String, String> entry : AjaxTableRenderer.this.getExtraParameter().entrySet()) {
                scriptValue = (String)scriptValue + "aoData.push({'name' : '" + entry.getKey() + "', 'value' : '" + entry.getValue() + "' });\n";
            }
            scriptValue = (String)scriptValue + "$.ajax({\n";
            scriptValue = (String)scriptValue + "'dataType': 'json',\n";
            scriptValue = (String)scriptValue + "'type': 'POST',\n";
            scriptValue = (String)scriptValue + "'url': sSource,\n";
            scriptValue = (String)scriptValue + "'data': aoData,\n";
            scriptValue = (String)scriptValue + "'success': fnCallback\n";
            scriptValue = (String)scriptValue + "});\n";
            scriptValue = (String)scriptValue + "},\n";
            scriptValue = (String)scriptValue + "'fnRowCallback': function(nRow, aData, iDisplayIndex) {\n";
            scriptValue = (String)scriptValue + "\t\treturn rowCallBackImpl(nRow, aData, iDisplayIndex);\n";
            scriptValue = (String)scriptValue + "},\n";
            scriptValue = (String)scriptValue + "'aoColumns': [\n";
            for (i = 0; i < columnNumber - (AjaxTableRenderer.this.getSortedLinksSize() > 0 ? 1 : 0); ++i) {
                scriptValue = (String)scriptValue + String.format("{ \"sClass\": \"%s\" },\n", this.getColumnClassesFor(i));
            }
            if (AjaxTableRenderer.this.getSortedLinksSize() > 0) {
                scriptValue = (String)scriptValue + "/*Links */ { \n";
                scriptValue = (String)scriptValue + "\t'bSortable': false,\n";
                scriptValue = (String)scriptValue + String.format("\t\"sClass\" : \"%s\",", this.getColumnClassesFor(columnNumber - 1));
                scriptValue = (String)scriptValue + "\t'fnRender': function(oObj) {\n";
                scriptValue = (String)scriptValue + "var links='';\n";
                for (i = 0; i < AjaxTableRenderer.this.getSortedLinksSize(); ++i) {
                    CollectionRenderer.TableLink link = AjaxTableRenderer.this.getTableLink(i);
                    String value = "";
                    if (link.getIcon() != null && !link.getIcon().equals("none")) {
                        HtmlLink forImage = new HtmlLink();
                        forImage.setModuleRelative(false);
                        forImage.setContextRelative(true);
                        forImage.setUrl("/images/" + link.getIcon() + ".gif");
                        value = String.format("<img src='%s' alt='%s' />", forImage.calculateUrl(), link.getLinkText(link, null));
                    } else {
                        value = link.getLinkText(link, null);
                    }
                    scriptValue = (String)scriptValue + "if(oObj.aData[" + (columnNumber - 1) + "].split(',')[" + i + "] != 'permission_not_granted')\n";
                    scriptValue = (String)scriptValue + "links += \"<\" + \"a href='\" + oObj.aData[" + (columnNumber - 1) + "].split(',')[" + i + "] + \"'>" + value + "</a>";
                    if (AjaxTableRenderer.this.getSortedLinksSize() > 1 && i < AjaxTableRenderer.this.getSortedLinksSize() - 1) {
                        scriptValue = (String)scriptValue + " ";
                    }
                    scriptValue = (String)scriptValue + "\"\n";
                }
                scriptValue = (String)scriptValue + "return links;\n";
            }
            scriptValue = (String)scriptValue + "}\n";
            scriptValue = (String)scriptValue + "},\n";
            scriptValue = (String)scriptValue + "{ /* Active */\n";
            scriptValue = (String)scriptValue + "\t'bSortable': false,\n";
            scriptValue = (String)scriptValue + "\t'sClass' : 'width0'\n";
            scriptValue = (String)scriptValue + "}\n";
            scriptValue = (String)scriptValue + "]\n";
            scriptValue = (String)scriptValue + "});\n";
            scriptValue = (String)scriptValue + "}\n";
            scriptValue = (String)scriptValue + ");\n";
            script.setScript((CharSequence)scriptValue);
            container.addChild(script);
        }

        private Object getColumnClassesFor(int i) {
            String[] columnClasses = this.getColumnClasses().split(",");
            if (i < columnClasses.length) {
                return columnClasses[i];
            }
            return "";
        }

        private String getAjaxTableLanguageConfiguration() {
            ResourceBundle bundle = ResourceBundle.getBundle("resources/RendererResources");
            String sProcessing = bundle.getString("label.renderers.ajax.table.sProcessing");
            String sLengthMenu = bundle.getString("label.renderers.ajax.table.sLengthMenu");
            String sZeroRecords = bundle.getString("label.renderers.ajax.table.sZeroRecords");
            String sInfo = bundle.getString("label.renderers.ajax.table.sInfo");
            String sInfoEmpty = bundle.getString("label.renderers.ajax.table.sInfoEmpty");
            String sInfoFiltered = bundle.getString("label.renderers.ajax.table.sInfoFiltered");
            String sInfoPostFix = bundle.getString("label.renderers.ajax.table.sInfoPostFix");
            String sSearch = bundle.getString("label.renderers.ajax.table.sSearch");
            String sFirst = bundle.getString("label.renderers.ajax.table.sFirst");
            String sPrevious = bundle.getString("label.renderers.ajax.table.sPrevious");
            String sNext = bundle.getString("label.renderers.ajax.table.sNext");
            String sLast = bundle.getString("label.renderers.ajax.table.sLast");
            Object returnValue = "";
            returnValue = (String)returnValue + "'oLanguage': {\n";
            returnValue = (String)returnValue + "\t'sProcessing': '" + sProcessing + "',\n";
            returnValue = (String)returnValue + "\t'sLengthMenu': '" + sLengthMenu + "',\n";
            returnValue = (String)returnValue + "\t'sZeroRecords': '" + sZeroRecords + "',\n";
            returnValue = (String)returnValue + "\t'sInfo': '" + sInfo + "',\n";
            returnValue = (String)returnValue + "\t'sInfoEmpty': '" + sInfoEmpty + "',\n";
            returnValue = (String)returnValue + "\t'sInfoFiltered': '" + sInfoFiltered + "',\n";
            returnValue = (String)returnValue + "\t'sInfoPostFix': '" + sInfoPostFix + "',\n";
            returnValue = (String)returnValue + "\t'sSearch': '" + sSearch + "',\n";
            returnValue = (String)returnValue + "\t'oPaginate': {\n";
            returnValue = (String)returnValue + "\t\t'sFirst': '" + sFirst + "',\n";
            returnValue = (String)returnValue + "\t\t'sPrevious': '" + sPrevious + "',\n";
            returnValue = (String)returnValue + "\t\t'sNext': '" + sNext + "',\n";
            returnValue = (String)returnValue + "\t\t'sLast': '" + sLast + "'\n";
            returnValue = (String)returnValue + "\t}\n";
            returnValue = (String)returnValue + "}";
            return returnValue;
        }

        private void addAjaxDataTableScript(HtmlInlineContainer container) {
            HtmlLink link = new HtmlLink();
            link.setModuleRelative(false);
            link.setContextRelative(true);
            link.setUrl("/javaScript/dataTables/media/js/jquery.dataTables.js");
            HtmlScript script = new HtmlScript("text/javascript", link.calculateUrl(), true);
            container.addChild(script);
        }

        @Override
        public void applyStyle(HtmlComponent component) {
            HtmlInlineContainer container = (HtmlInlineContainer)component;
            HtmlTable table = (HtmlTable)container.getChildren().get(2);
            table.setClasses(this.getClasses() + " ajax-table");
            table.setStyle(this.getStyle());
            table.setTitle(this.getTitle());
            table.setCaption(this.getCaption());
            table.setSummary(this.getSummary());
            if (this.getHeaderClasses() != null) {
                HtmlTableHeader header;
                String[] headerClasses = null;
                if (this.getHeaderClasses() != null) {
                    headerClasses = this.getHeaderClasses().split(",", -1);
                }
                if ((header = table.getHeader()) != null) {
                    for (HtmlTableRow row : header.getRows()) {
                        int cellIndex = 0;
                        for (HtmlTableCell cell : row.getCells()) {
                            String choosenCellClass = headerClasses[cellIndex % headerClasses.length];
                            cell.setClasses(choosenCellClass);
                            ++cellIndex;
                        }
                    }
                }
            }
            String[] rowClasses = null;
            if (this.getRowClasses() != null) {
                rowClasses = this.getRowClasses().split(",", -1);
            }
            String[] cellClasses = null;
            if (this.getColumnClasses() != null) {
                cellClasses = this.getColumnClasses().split(",", -1);
            }
            if (rowClasses == null && cellClasses == null) {
                return;
            }
            int rowIndex = 0;
            for (HtmlTableRow row : table.getRows()) {
                String chooseRowClass;
                if (rowClasses != null && !(chooseRowClass = rowClasses[rowIndex % rowClasses.length]).equals("")) {
                    row.setClasses(chooseRowClass);
                }
                if (cellClasses != null) {
                    int cellIndex = 0;
                    for (HtmlTableCell cell : row.getCells()) {
                        String chooseCellClass = cellClasses[cellIndex % cellClasses.length];
                        if (!chooseCellClass.equals("")) {
                            cell.setClasses(chooseCellClass);
                        }
                        ++cellIndex;
                    }
                }
                ++rowIndex;
            }
        }
    }
}

