/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlFormComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlTextInput;
import pt.ist.fenixWebFramework.renderers.contexts.InputContext;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaSlotKey;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public abstract class TextFieldRenderer
extends InputRenderer {
    private boolean disabled;
    private boolean readOnly;
    private String size;
    private Integer maxLength;
    private String formatText;
    private String bundle;
    private boolean key;

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public boolean isKey() {
        return this.key;
    }

    public void setKey(boolean key) {
        this.key = key;
    }

    public String getFormatText() {
        return this.formatText;
    }

    public void setFormatText(String formatText) {
        this.formatText = formatText;
    }

    public String getBundle() {
        return this.bundle;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new TextFieldLayout();
    }

    protected String getFormatLabel() {
        if (this.isKey()) {
            return RenderUtils.getResourceString(this.getBundle(), this.getFormatText());
        }
        if (this.getFormatText() != null) {
            return this.getFormatText();
        }
        return "";
    }

    protected abstract HtmlComponent createTextField(Object var1, Class var2);

    protected class TextFieldLayout
    extends Layout {
        protected TextFieldLayout() {
        }

        @Override
        public HtmlComponent createComponent(Object object, Class type) {
            HtmlComponent component = TextFieldRenderer.this.createTextField(object, type);
            InputContext context = TextFieldRenderer.this.getInputContext();
            this.setContextSlot(component, (MetaSlotKey)context.getMetaObject().getKey());
            return component;
        }

        protected void setContextSlot(HtmlComponent component, MetaSlotKey slotKey) {
            ((HtmlFormComponent)component).setTargetSlot(slotKey);
        }

        @Override
        public void applyStyle(HtmlComponent component) {
            super.applyStyle(component);
            HtmlTextInput textInput = (HtmlTextInput)component;
            textInput.setMaxLength(TextFieldRenderer.this.getMaxLength());
            textInput.setSize(TextFieldRenderer.this.getSize());
            textInput.setReadOnly(TextFieldRenderer.this.getReadOnly());
            textInput.setDisabled(TextFieldRenderer.this.getDisabled());
        }
    }
}

