/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pt.ist.fenixWebFramework.renderers.SelectionRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlCheckBox;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlMultipleHiddenField;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.controllers.HtmlController;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.layouts.TabularLayout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectCollection;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectFactory;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class TabularOptionInputRenderer
extends SelectionRenderer {
    private String classes;
    private String emptyMessageKey;
    private String emptyMessageBundle;
    private String columnClasses;

    public String getColumnClasses() {
        return this.columnClasses;
    }

    public void setColumnClasses(String columnClasses) {
        this.columnClasses = columnClasses;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        List<MetaObject> metaObjects = this.getMetaObjects(this.getPossibleObjects());
        Collection objectsReceived = (Collection)object;
        HtmlMultipleHiddenField hiddenField = new HtmlMultipleHiddenField();
        hiddenField.bind((MetaSlot)this.getContext().getMetaObject());
        hiddenField.setConverter(this.getConverter());
        return new CheckableTabularLayout(metaObjects, objectsReceived, hiddenField);
    }

    private List<MetaObject> getMetaObjects(Collection collection) {
        ArrayList<MetaObject> metaObjects = new ArrayList<MetaObject>();
        MetaObject contextMetaObject = this.getContext().getMetaObject();
        if (contextMetaObject instanceof MetaObjectCollection) {
            MetaObjectCollection multipleMetaObject = (MetaObjectCollection)this.getContext().getMetaObject();
            block0: for (Object object : collection) {
                for (MetaObject metaObject : multipleMetaObject.getAllMetaObjects()) {
                    if (!object.equals(metaObject.getObject())) continue;
                    metaObjects.add(metaObject);
                    continue block0;
                }
            }
        } else {
            Schema schema = this.getContext().getSchema();
            for (Object object : collection) {
                metaObjects.add(MetaObjectFactory.createObject(object, schema));
            }
        }
        return metaObjects;
    }

    @Override
    public String getClasses() {
        return this.classes;
    }

    @Override
    public void setClasses(String classes) {
        this.classes = classes;
    }

    public String getEmptyMessageBundle() {
        return this.emptyMessageBundle;
    }

    public void setEmptyMessageBundle(String emptyMessageBundle) {
        this.emptyMessageBundle = emptyMessageBundle;
    }

    public String getEmptyMessageKey() {
        return this.emptyMessageKey;
    }

    public void setEmptyMessageKey(String emptyMessageKey) {
        this.emptyMessageKey = emptyMessageKey;
    }

    public class CheckableTabularLayout
    extends TabularLayout {
        protected List<MetaObject> metaObjects;
        protected Collection<?> objectsReceived;
        protected HtmlMultipleHiddenField hiddenField;
        protected List<HtmlCheckBox> checkboxes = new ArrayList<HtmlCheckBox>();

        public CheckableTabularLayout(List<MetaObject> metaObjects, Collection<?> collection, HtmlMultipleHiddenField hiddenField) {
            this.metaObjects = metaObjects;
            this.objectsReceived = collection;
            this.hiddenField = hiddenField;
        }

        public HtmlMultipleHiddenField getHiddenField() {
            return this.hiddenField;
        }

        public List<HtmlCheckBox> getCheckBoxes() {
            return this.checkboxes;
        }

        @Override
        public HtmlComponent createLayout(Object object, Class type) {
            HtmlInlineContainer container = new HtmlInlineContainer();
            HtmlComponent component = super.createLayout(object, type);
            container.addChild(this.hiddenField);
            container.addChild(component);
            if (this.metaObjects.isEmpty() && !Strings.isNullOrEmpty((String)TabularOptionInputRenderer.this.getEmptyMessageKey())) {
                HtmlText emptyMessage = new HtmlText(RenderUtils.getResourceString(TabularOptionInputRenderer.this.getEmptyMessageBundle(), TabularOptionInputRenderer.this.getEmptyMessageKey()), false);
                container.addChild(emptyMessage);
            }
            this.hiddenField.setController(new HtmlController(){

                @Override
                public void execute(IViewState viewState) {
                    ArrayList<String> values = new ArrayList<String>();
                    for (HtmlCheckBox checkBox : CheckableTabularLayout.this.checkboxes) {
                        if (!checkBox.isChecked()) continue;
                        values.add(checkBox.getValue());
                    }
                    CheckableTabularLayout.this.hiddenField.setValues(values.toArray(new String[0]));
                }
            });
            return container;
        }

        @Override
        protected boolean hasHeader() {
            return this.metaObjects.size() > 0;
        }

        @Override
        protected HtmlComponent getHeaderComponent(int columnIndex) {
            String text = "";
            if (columnIndex != 0) {
                text = this.metaObjects.get(0).getSlots().get(columnIndex - 1).getLabel();
            }
            return new HtmlText(text, false);
        }

        @Override
        protected int getNumberOfColumns() {
            if (this.metaObjects.size() > 0) {
                MetaObject metaObject = this.metaObjects.get(0);
                return metaObject.getSlots().size() + 1;
            }
            return 0;
        }

        @Override
        protected int getNumberOfRows() {
            return this.metaObjects.size();
        }

        @Override
        protected HtmlComponent getComponent(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                HtmlCheckBox checkBox = new HtmlCheckBox();
                this.checkboxes.add(checkBox);
                MetaObject metaObject = this.metaObjects.get(rowIndex);
                checkBox.setUserValue(metaObject.getKey().toString());
                checkBox.setName(this.hiddenField.getName() + "/" + metaObject.getKey().toString());
                if (this.objectsReceived != null && this.objectsReceived.contains(metaObject.getObject())) {
                    checkBox.setChecked(true);
                }
                return checkBox;
            }
            MetaSlot slot = this.getSlotUsingName(this.metaObjects.get(rowIndex), columnIndex - 1);
            slot.setReadOnly(true);
            return TabularOptionInputRenderer.this.renderSlot(slot);
        }

        protected MetaSlot getSlotUsingName(MetaObject object, int columnIndex) {
            MetaObject referenceObject = this.metaObjects.get(0);
            MetaSlot referenceSlot = referenceObject.getSlots().get(columnIndex);
            MetaSlot directSlot = object.getSlots().get(columnIndex);
            if (directSlot.getName().equals(referenceSlot.getName())) {
                return directSlot;
            }
            for (MetaSlot slot : object.getSlots()) {
                if (!slot.getName().equals(referenceSlot.getName())) continue;
                return slot;
            }
            return null;
        }
    }
}

