/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import pt.ist.fenixWebFramework.renderers.CollectionRenderer;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlInputComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlSimpleValueComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.Validatable;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.layouts.TabularLayout;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;

public class TabularInputRenderer
extends InputRenderer {
    private CollectionRenderer collectionRenderer = new CollectionRenderer(){

        @Override
        protected HtmlComponent renderSlot(MetaSlot slot) {
            return TabularInputRenderer.this.renderSlot(slot);
        }
    };
    private String validatorClasses;
    private boolean hideValidators = true;
    private boolean allValidatorsInline = false;

    @Override
    public String getClasses() {
        return this.collectionRenderer.getClasses();
    }

    @Override
    public String getStyle() {
        return this.collectionRenderer.getStyle();
    }

    @Override
    public String getTitle() {
        return this.collectionRenderer.getTitle();
    }

    public String getCaption() {
        return this.collectionRenderer.getCaption();
    }

    public String getSummary() {
        return this.collectionRenderer.getSummary();
    }

    public String getHeaderClasses() {
        return this.collectionRenderer.getHeaderClasses();
    }

    public String getColumnClasses() {
        return this.collectionRenderer.getColumnClasses();
    }

    public String getRowClasses() {
        return this.collectionRenderer.getRowClasses();
    }

    public String getPrefixes() {
        return this.collectionRenderer.getPrefixes();
    }

    public String getSuffixes() {
        return this.collectionRenderer.getSuffixes();
    }

    public String getBundle(String name) {
        return this.collectionRenderer.getBundle(name);
    }

    public String getKey(String name) {
        return this.collectionRenderer.getKey(name);
    }

    public String getLink(String name) {
        return this.collectionRenderer.getLink(name);
    }

    public String getModule(String name) {
        return this.collectionRenderer.getModule(name);
    }

    public String getOrder(String name) {
        return this.collectionRenderer.getOrder(name);
    }

    public String getParam(String name) {
        return this.collectionRenderer.getParam(name);
    }

    public String getText(String name) {
        return this.collectionRenderer.getText(name);
    }

    public boolean isExcludedFromFirst(String name) {
        return this.collectionRenderer.isExcludedFromFirst(name);
    }

    public boolean isExcludedFromLast(String name) {
        return this.collectionRenderer.isExcludedFromLast(name);
    }

    public String getVisibleIf(String name) {
        return this.collectionRenderer.getVisibleIf(name);
    }

    public String getVisibleIfNot(String name) {
        return this.collectionRenderer.getVisibleIfNot(name);
    }

    public String getLinkFormat(String name) {
        return this.collectionRenderer.getLinkFormat(name);
    }

    public String getContextRelative(String name) {
        return this.collectionRenderer.getContextRelative(name);
    }

    public String getCustomLink(String name) {
        return this.collectionRenderer.getCustomLink(name);
    }

    public boolean getDisplayHeaders() {
        return this.collectionRenderer.getDisplayHeaders();
    }

    public String getLinkGroupSeparator() {
        return this.collectionRenderer.getLinkGroupSeparator();
    }

    public boolean isGroupLinks() {
        return this.collectionRenderer.isGroupLinks();
    }

    public boolean isRowForLinks() {
        return this.collectionRenderer.isRowForLinks();
    }

    public void setCaption(String caption) {
        this.collectionRenderer.setCaption(caption);
    }

    public void setSummary(String summary) {
        this.collectionRenderer.setSummary(summary);
    }

    @Override
    public void setClasses(String classes) {
        this.collectionRenderer.setClasses(classes);
    }

    @Override
    public void setStyle(String style) {
        this.collectionRenderer.setStyle(style);
    }

    @Override
    public void setTitle(String title) {
        this.collectionRenderer.setTitle(title);
    }

    public void setHeaderClasses(String headerClasses) {
        this.collectionRenderer.setHeaderClasses(headerClasses);
    }

    public void setColumnClasses(String columnClasses) {
        this.collectionRenderer.setColumnClasses(columnClasses);
    }

    public void setRowClasses(String rowClasses) {
        this.collectionRenderer.setRowClasses(rowClasses);
    }

    public void setPrefixes(String prefixes) {
        this.collectionRenderer.setPrefixes(prefixes);
    }

    public void setSuffixes(String suffixes) {
        this.collectionRenderer.setSuffixes(suffixes);
    }

    public void setSortBy(String sortBy) {
        this.collectionRenderer.setSortBy(sortBy);
    }

    public void setBundle(String name, String value) {
        this.collectionRenderer.setBundle(name, value);
    }

    public void setKey(String name, String value) {
        this.collectionRenderer.setKey(name, value);
    }

    public void setLink(String name, String value) {
        this.collectionRenderer.setLink(name, value);
    }

    public void setModule(String name, String value) {
        this.collectionRenderer.setModule(name, value);
    }

    public void setOrder(String name, String value) {
        this.collectionRenderer.setOrder(name, value);
    }

    public void setParam(String name, String value) {
        this.collectionRenderer.setParam(name, value);
    }

    public void setText(String name, String value) {
        this.collectionRenderer.setText(name, value);
    }

    public void setExcludedFromFirst(String name, String value) {
        this.collectionRenderer.setExcludedFromFirst(name, value);
    }

    public void setExcludedFromLast(String name, String value) {
        this.collectionRenderer.setExcludedFromLast(name, value);
    }

    public void setVisibleIf(String name, String value) {
        this.collectionRenderer.setVisibleIf(name, value);
    }

    public void setVisibleIfNot(String name, String value) {
        this.collectionRenderer.setVisibleIfNot(name, value);
    }

    public void setLinkFormat(String name, String value) {
        this.collectionRenderer.setLinkFormat(name, value);
    }

    public void setContextRelative(String name, String value) {
        this.collectionRenderer.setContextRelative(name, value);
    }

    public void setCustomLink(String name, String value) {
        this.collectionRenderer.setCustomLink(name, value);
    }

    public void setDisplayHeaders(boolean displayHeaders) {
        this.collectionRenderer.setDisplayHeaders(displayHeaders);
    }

    public void setGroupLinks(boolean groupLinks) {
        this.collectionRenderer.setGroupLinks(groupLinks);
    }

    public void setLinkGroupSeparator(String linkGroupSeparator) {
        this.collectionRenderer.setLinkGroupSeparator(linkGroupSeparator);
    }

    public void setRowForLinks(boolean rowForLinks) {
        this.collectionRenderer.setRowForLinks(rowForLinks);
    }

    public String getValidatorClasses() {
        return this.validatorClasses;
    }

    public void setValidatorClasses(String validatorClasses) {
        this.validatorClasses = validatorClasses;
    }

    public boolean isHideValidators() {
        return this.hideValidators;
    }

    public void setHideValidators(boolean hideValidators) {
        this.hideValidators = hideValidators;
    }

    public void setAllValidatorsInline(boolean allValidatorsInline) {
        this.allValidatorsInline = allValidatorsInline;
    }

    public boolean isAllValidatorsInline() {
        return this.allValidatorsInline;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        this.collectionRenderer.setContext(this.getContext());
        final CollectionRenderer.CollectionTabularLayout layout = (CollectionRenderer.CollectionTabularLayout)this.collectionRenderer.getLayout(object, type);
        return new TabularLayout(){

            @Override
            protected boolean hasHeader() {
                return layout.hasHeader();
            }

            @Override
            protected int getNumberOfColumns() {
                return layout.getNumberOfColumns();
            }

            @Override
            protected int getNumberOfRows() {
                return layout.getNumberOfRows();
            }

            @Override
            protected HtmlComponent getHeaderComponent(int columnIndex) {
                return layout.getHeaderComponent(columnIndex);
            }

            @Override
            protected HtmlComponent getComponent(int rowIndex, int columnIndex) {
                HtmlComponent component = layout.getComponent(rowIndex, columnIndex);
                Validatable validatable = TabularInputRenderer.this.findValidatableComponent(component);
                if (validatable instanceof HtmlInputComponent) {
                    HtmlInputComponent input = (HtmlInputComponent)validatable;
                    String label = layout.getLabel(columnIndex);
                    if (label != null && label.length() > 0) {
                        input.setAlternateText(HtmlText.escape(label));
                    }
                    component = this.addInlineValidators(columnIndex, component, input);
                } else if (TabularInputRenderer.this.isAllValidatorsInline()) {
                    HtmlSimpleValueComponent input = (HtmlSimpleValueComponent)validatable;
                    component = this.addInlineValidators(columnIndex, component, input);
                }
                return component;
            }

            private HtmlComponent addInlineValidators(int columnIndex, HtmlComponent component, HtmlSimpleValueComponent input) {
                MetaSlot metaSlot = TabularInputRenderer.this.getContext().getMetaObject().getSlots().get(columnIndex);
                HtmlChainValidator chainValidator = TabularInputRenderer.this.getChainValidator(input, metaSlot);
                if (chainValidator != null && !chainValidator.isEmpty() && !TabularInputRenderer.this.isHideValidators()) {
                    chainValidator.setClasses(TabularInputRenderer.this.getValidatorClasses());
                    if (component instanceof HtmlContainer) {
                        HtmlContainer container = (HtmlContainer)component;
                        container.addChild(chainValidator);
                    } else {
                        HtmlInlineContainer container = new HtmlInlineContainer();
                        container.addChild(component);
                        container.addChild(chainValidator);
                        return container;
                    }
                }
                return component;
            }
        };
    }
}

