/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import com.google.common.base.Predicate;
import pt.ist.fenixWebFramework.renderers.TextFieldRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.HtmlTextInput;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaSlotKey;

public class StringInputRenderer
extends TextFieldRenderer {
    @Override
    protected HtmlComponent createTextField(Object object, Class type) {
        String string = (String)object;
        HtmlTextInput input = new HtmlTextInput();
        input.setValue(string);
        HtmlInlineContainer container = new HtmlInlineContainer();
        container.addChild(input);
        container.addChild(new HtmlText(this.getFormatLabel()));
        return container;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new StringInputFieldLayout();
    }

    class StringInputFieldLayout
    extends TextFieldRenderer.TextFieldLayout {
        StringInputFieldLayout() {
        }

        @Override
        protected void setContextSlot(HtmlComponent component, MetaSlotKey slotKey) {
            HtmlComponent actualComponent = component instanceof HtmlTextInput ? component : component.getChild(new Predicate<HtmlComponent>(){

                public boolean apply(HtmlComponent component) {
                    return component instanceof HtmlTextInput;
                }
            });
            super.setContextSlot(actualComponent, slotKey);
        }

        @Override
        public void applyStyle(HtmlComponent component) {
            HtmlComponent actualComponent = component instanceof HtmlTextInput ? component : component.getChild(new Predicate<HtmlComponent>(){

                public boolean apply(HtmlComponent component) {
                    return component instanceof HtmlTextInput;
                }
            });
            super.applyStyle(actualComponent);
        }
    }
}

