/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import java.util.Collection;
import java.util.List;
import pt.ist.fenixWebFramework.renderers.CollectionRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlActionLink;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlImage;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlLink;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.state.ViewDestination;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class OrderableCollectionRenderer
extends CollectionRenderer {
    private static final String AL_ON_CLICK = "document.getElementById('%s').%s.value='%s=%s';";
    private String sortFormId;
    private boolean sortActionLink = false;
    private String sortUrl;
    private String sortParameter;
    private String ascendingClasses;
    private String descendingClasses;
    private String ascendingImage;
    private String descendingImage;
    private boolean contextRelative;
    private String sortableSlots;
    private boolean sortIgnored;

    public boolean isSortIgnored() {
        return this.sortIgnored;
    }

    public void setSortIgnored(boolean sortIgnored) {
        this.sortIgnored = sortIgnored;
    }

    public OrderableCollectionRenderer() {
        this.setContextRelative(true);
    }

    public String getAscendingClasses() {
        return this.ascendingClasses;
    }

    public String getDescendingClasses() {
        return this.descendingClasses;
    }

    public String getAscendingImage() {
        return this.ascendingImage;
    }

    public String getDescendingImage() {
        return this.descendingImage;
    }

    public boolean isContextRelative() {
        return this.contextRelative;
    }

    public String getSortFormId() {
        return this.sortFormId;
    }

    public void setSortFormId(String sortFormId) {
        this.sortFormId = sortFormId;
    }

    public boolean isSortActionLink() {
        return this.sortActionLink;
    }

    public void setSortActionLink(boolean sortActionLink) {
        this.sortActionLink = sortActionLink;
    }

    public String getSortUrl() {
        return this.sortUrl;
    }

    public void setSortUrl(String sortUrl) {
        this.sortUrl = sortUrl;
    }

    public String getSortParameter() {
        return this.sortParameter;
    }

    public void setSortParameter(String sortParameter) {
        this.sortParameter = sortParameter;
    }

    public void setAscendingClasses(String ascendingClasses) {
        this.ascendingClasses = ascendingClasses;
    }

    public void setDescendingClasses(String descendingClasses) {
        this.descendingClasses = descendingClasses;
    }

    public void setAscendingImage(String ascendingImage) {
        this.ascendingImage = ascendingImage;
    }

    public void setDescendingImage(String descendingImage) {
        this.descendingImage = descendingImage;
    }

    public void setContextRelative(boolean contextRelative) {
        this.contextRelative = contextRelative;
    }

    public String getSortableSlots() {
        return this.sortableSlots;
    }

    public void setSortableSlots(String sortableSlots) {
        this.sortableSlots = sortableSlots;
    }

    private String getImagePath(String path) {
        if (this.isContextRelative()) {
            return this.getContext().getViewState().getRequest().getContextPath() + path;
        }
        return path;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        List sortedCollection = this.isSortIgnored() ? (List)object : RenderUtils.sortCollectionWithCriteria((Collection)object, this.getSortBy());
        return new OrderedCollectionTabularLayout(sortedCollection);
    }

    protected class OrderedCollectionTabularLayout
    extends CollectionRenderer.CollectionTabularLayout {
        public OrderedCollectionTabularLayout(Collection object) {
            super(OrderableCollectionRenderer.this, object);
        }

        @Override
        protected HtmlComponent getHeaderComponent(int columnIndex) {
            if (columnIndex == 0 && OrderableCollectionRenderer.this.isCheckable()) {
                return new HtmlText();
            }
            if (columnIndex < this.getNumberOfColumns() - OrderableCollectionRenderer.this.getNumberOfLinkColumns()) {
                HtmlComponent component = super.getHeaderComponent(columnIndex);
                String slotName = this.getObject(0).getSlots().get(columnIndex - (OrderableCollectionRenderer.this.isCheckable() ? 1 : 0)).getName();
                if (!this.isSortable(slotName)) {
                    return component;
                }
                if (OrderableCollectionRenderer.this.isSortActionLink()) {
                    return this.buildActionLink(component, slotName);
                }
                HtmlLink link = new HtmlLink();
                if (OrderableCollectionRenderer.this.getSortUrl() != null) {
                    link.setUrl(OrderableCollectionRenderer.this.getSortUrl());
                } else {
                    ViewDestination destination = OrderableCollectionRenderer.this.getContext().getViewState().getInputDestination();
                    link.setModule(destination.getModule());
                    link.setUrl(destination.getPath());
                }
                link.setBody(component);
                if (OrderableCollectionRenderer.this.getSortBy() != null && OrderableCollectionRenderer.this.getSortBy().contains(slotName)) {
                    if (OrderableCollectionRenderer.this.getSortBy().contains("=desc")) {
                        link.setParameter(OrderableCollectionRenderer.this.getSortParameter(), slotName + "=ascending");
                        component = this.wrapComponent(link, false);
                    } else {
                        link.setParameter(OrderableCollectionRenderer.this.getSortParameter(), slotName + "=descending");
                        component = this.wrapComponent(link, true);
                    }
                } else {
                    link.setParameter(OrderableCollectionRenderer.this.getSortParameter(), slotName + "=ascending");
                    component = this.wrapComponent(link, false);
                }
                return component;
            }
            return new HtmlText();
        }

        private HtmlComponent buildActionLink(HtmlComponent component, String slotName) {
            HtmlComponent result;
            HtmlActionLink link = new HtmlActionLink();
            link.setBody(component);
            if (OrderableCollectionRenderer.this.getSortBy() != null && OrderableCollectionRenderer.this.getSortBy().contains(slotName)) {
                if (OrderableCollectionRenderer.this.getSortBy().contains("=desc")) {
                    link.setOnClick(String.format(OrderableCollectionRenderer.AL_ON_CLICK, OrderableCollectionRenderer.this.getSortFormId(), OrderableCollectionRenderer.this.getSortParameter(), slotName, "asc"));
                    result = this.wrapComponent(link, false);
                } else {
                    link.setOnClick(String.format(OrderableCollectionRenderer.AL_ON_CLICK, OrderableCollectionRenderer.this.getSortFormId(), OrderableCollectionRenderer.this.getSortParameter(), slotName, "desc"));
                    result = this.wrapComponent(link, true);
                }
            } else {
                link.setOnClick(String.format(OrderableCollectionRenderer.AL_ON_CLICK, OrderableCollectionRenderer.this.getSortFormId(), OrderableCollectionRenderer.this.getSortParameter(), slotName, "asc"));
                result = this.wrapComponent(link, false);
            }
            return result;
        }

        private boolean isSortable(String slotName) {
            String[] slots;
            String sortableSlots = OrderableCollectionRenderer.this.getSortableSlots();
            if (sortableSlots == null) {
                return true;
            }
            for (String slot : slots = sortableSlots.split(",")) {
                String trimmed = slot.trim();
                if (trimmed.length() == 0 || !trimmed.equals(slotName)) continue;
                return true;
            }
            return false;
        }

        private HtmlComponent wrapComponent(HtmlComponent component, boolean ascending) {
            String image = null;
            if (ascending) {
                if (OrderableCollectionRenderer.this.getAscendingClasses() != null) {
                    component.setClasses(OrderableCollectionRenderer.this.getAscendingClasses());
                }
                image = OrderableCollectionRenderer.this.getAscendingImage();
            } else {
                if (OrderableCollectionRenderer.this.getDescendingClasses() != null) {
                    component.setClasses(OrderableCollectionRenderer.this.getDescendingClasses());
                }
                image = OrderableCollectionRenderer.this.getDescendingImage();
            }
            if (image == null) {
                return component;
            }
            HtmlInlineContainer container = new HtmlInlineContainer();
            HtmlImage htmlImage = new HtmlImage();
            htmlImage.setSource(OrderableCollectionRenderer.this.getImagePath(image));
            container.addChild(htmlImage);
            container.addChild(component);
            return container;
        }
    }
}

