/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class IntegerRenderer
extends OutputRenderer {
    private int base;
    private String prefix;
    private String suffix;
    private String bundle;

    public int getBase() {
        return this.base;
    }

    public void setBase(int base) {
        this.base = base;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            @Override
            public HtmlComponent createComponent(Object object, Class type) {
                Number number = (Number)object;
                String text = number != null && number instanceof Integer ? Integer.toString(number.intValue(), IntegerRenderer.this.getBase()) : (number == null ? "" : number.toString());
                String prefixString = RenderUtils.getResourceString(IntegerRenderer.this.getBundle(), IntegerRenderer.this.prefix);
                String suffixString = RenderUtils.getResourceString(IntegerRenderer.this.getBundle(), IntegerRenderer.this.suffix);
                if (prefixString != null || suffixString != null) {
                    StringBuilder strBuilder = prefixString == null ? new StringBuilder() : new StringBuilder(prefixString);
                    strBuilder.append(text);
                    strBuilder.append(suffixString);
                    text = strBuilder.toString();
                }
                return new HtmlText(text);
            }
        };
    }
}

