/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import com.google.common.base.Predicate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixWebFramework.renderers.Renderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlFormComponent;
import pt.ist.fenixWebFramework.renderers.components.Validatable;
import pt.ist.fenixWebFramework.renderers.contexts.InputContext;
import pt.ist.fenixWebFramework.renderers.contexts.PresentationContext;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;
import pt.ist.fenixWebFramework.renderers.utils.RenderMode;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;

public abstract class InputRenderer
extends Renderer {
    private static final Logger logger = LoggerFactory.getLogger(InputRenderer.class);

    public InputContext getInputContext() {
        return (InputContext)this.getContext();
    }

    protected Validatable findValidatableComponent(HtmlComponent component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Validatable) {
            return (Validatable)((Object)component);
        }
        List<HtmlComponent> children = component.getChildren(new Predicate<HtmlComponent>(){

            public boolean apply(HtmlComponent component) {
                if (!(component instanceof HtmlFormComponent)) {
                    return false;
                }
                HtmlFormComponent formComponent = (HtmlFormComponent)component;
                return formComponent.hasTargetSlot();
            }
        });
        if (children.size() > 0) {
            return (Validatable)((Object)children.get(0));
        }
        return null;
    }

    protected HtmlChainValidator getChainValidator(Validatable inputComponent, MetaSlot slot) {
        if (inputComponent == null) {
            return null;
        }
        HtmlChainValidator chainValidator = new HtmlChainValidator(inputComponent);
        for (HtmlValidator validator : slot.getValidatorsList()) {
            chainValidator.addValidator(validator);
        }
        return chainValidator;
    }

    @Override
    protected HtmlComponent renderSlot(MetaSlot slot) {
        PresentationContext newContext = this.getContext().createSubContext(slot);
        newContext.setSchema(slot.getSchema() != null ? slot.getSchema() : null);
        newContext.setLayout(slot.getLayout());
        newContext.setProperties(slot.getProperties());
        if (slot.isReadOnly()) {
            newContext.setRenderMode(RenderMode.OUTPUT);
        }
        Object value = slot.getObject();
        Class type = slot.getType();
        RenderKit kit = RenderKit.getInstance();
        return kit.render(newContext, value, type);
    }
}

