/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.contexts.InputContext;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class GenericInputWithComment
extends InputRenderer {
    private static final String LOCATION_TOP = "top";
    private static final String LOCATION_BOTTOM = "bottom";
    private static final String LOCATION_RIGHT = "right";
    private String bundle;
    private String comment;
    private String commentClasses;
    private String commentLocation = "bottom";
    private String subLayout;
    private Map<String, String> properties = new HashMap<String, String>();

    private Map<String, String> getPropertiesMap() {
        return this.properties;
    }

    public void setSubProperty(String property, String value) {
        this.properties.put(property, value);
    }

    public String getSubProperty(String property) {
        return this.properties.get(property);
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getCommentClasses() {
        return this.commentClasses;
    }

    public void setCommentClasses(String commentClasses) {
        this.commentClasses = commentClasses;
    }

    public String getSubLayout() {
        return this.subLayout;
    }

    public void setSubLayout(String subLayout) {
        this.subLayout = subLayout;
    }

    public String getCommentLocation() {
        return this.commentLocation;
    }

    public void setCommentLocation(String commentLocation) {
        this.commentLocation = commentLocation;
        if (this.commentLocation != null) {
            this.commentLocation = this.commentLocation.toLowerCase();
        }
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            private Properties getProperties() {
                Properties properties = new Properties();
                Map<String, String> map = GenericInputWithComment.this.getPropertiesMap();
                for (String property : map.keySet()) {
                    properties.put(property, map.get(property));
                }
                return properties;
            }

            @Override
            public HtmlComponent createComponent(Object object, Class type) {
                InputContext context = GenericInputWithComment.this.getInputContext();
                context.setLayout(GenericInputWithComment.this.getSubLayout());
                context.setProperties(this.getProperties());
                HtmlComponent component = RenderKit.getInstance().render(context, object, type);
                HtmlText text = new HtmlText(GenericInputWithComment.this.getBundle() != null ? RenderUtils.getResourceString(GenericInputWithComment.this.getBundle(), GenericInputWithComment.this.getComment()) : GenericInputWithComment.this.getComment(), GenericInputWithComment.this.getBundle() == null);
                text.setClasses(GenericInputWithComment.this.getCommentClasses());
                HtmlBlockContainer container = new HtmlBlockContainer();
                String commentLocation = String.valueOf(GenericInputWithComment.this.getCommentLocation());
                if (commentLocation.contains(GenericInputWithComment.LOCATION_TOP)) {
                    container.addChild(text);
                    container.addChild(new HtmlText("<br/>", false));
                    container.addChild(component);
                } else if (commentLocation.contains(GenericInputWithComment.LOCATION_RIGHT)) {
                    container.addChild(component);
                    container.addChild(text);
                } else {
                    container.addChild(component);
                    container.addChild(new HtmlText("<br/>", false));
                    container.addChild(text);
                }
                return container;
            }
        };
    }
}

