/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.beanutils.PropertyUtils;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlInputFile;
import pt.ist.fenixWebFramework.renderers.components.HtmlSimpleValueComponent;
import pt.ist.fenixWebFramework.renderers.components.controllers.HtmlController;
import pt.ist.fenixWebFramework.renderers.components.converters.ConversionException;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixWebFramework.renderers.model.MetaSlotKey;
import pt.ist.fenixWebFramework.renderers.plugin.RenderersRequestProcessorImpl;
import pt.ist.fenixWebFramework.servlets.commons.UploadedFile;

public class FileInputRenderer
extends InputRenderer {
    private String size;
    private String fileNameSlot;
    private String fileSizeSlot;
    private String fileContentTypeSlot;
    private String onChangeEvent;

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getFileContentTypeSlot() {
        return this.fileContentTypeSlot;
    }

    public void setFileContentTypeSlot(String fileContentTypeSlot) {
        this.fileContentTypeSlot = fileContentTypeSlot;
    }

    public String getFileNameSlot() {
        return this.fileNameSlot;
    }

    public void setFileNameSlot(String fileNameSlot) {
        this.fileNameSlot = fileNameSlot;
    }

    public String getFileSizeSlot() {
        return this.fileSizeSlot;
    }

    public void setFileSizeSlot(String fileSizeSlot) {
        this.fileSizeSlot = fileSizeSlot;
    }

    public String getOnChangeEvent() {
        return this.onChangeEvent;
    }

    public void setOnChangeEvent(String onChangeEvent) {
        this.onChangeEvent = onChangeEvent;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            @Override
            public HtmlComponent createComponent(Object object, Class type) {
                FileInputRenderer.this.getInputContext().getForm().setEncoding("multipart/form-data");
                HtmlInputFile file = new HtmlInputFile();
                file.setTargetSlot((MetaSlotKey)FileInputRenderer.this.getInputContext().getMetaObject().getKey());
                file.setController(new UpdateFilePropertiesController(((MetaSlot)FileInputRenderer.this.getInputContext().getMetaObject()).getMetaObject(), FileInputRenderer.this.getFileNameSlot(), FileInputRenderer.this.getFileSizeSlot(), FileInputRenderer.this.getFileContentTypeSlot()));
                file.setConverter(new FileConverter(file));
                if (FileInputRenderer.this.getOnChangeEvent() != null) {
                    file.setAttribute("onchange", FileInputRenderer.this.getOnChangeEvent());
                }
                return file;
            }

            @Override
            public void applyStyle(HtmlComponent component) {
                super.applyStyle(component);
                ((HtmlInputFile)component).setSize(FileInputRenderer.this.getSize());
            }
        };
    }

    private static class FileConverter
    extends Converter {
        private HtmlInputFile component;

        public FileConverter(HtmlInputFile file) {
            this.component = file;
        }

        @Override
        public Object convert(Class type, Object value) {
            String name = this.component.getName();
            UploadedFile file = RenderersRequestProcessorImpl.getUploadedFile(name);
            if (file == null) {
                return null;
            }
            try {
                return file.getInputStream();
            }
            catch (IOException e) {
                throw new ConversionException("renderers.converter.file.obtain", (Throwable)e, true, (Object[])null);
            }
        }
    }

    private static class UpdateFilePropertiesController
    extends HtmlController {
        private MetaObject object;
        private String fileNameSlot;
        private String fileSizeSlot;
        private String fileContentTypeSlot;

        public UpdateFilePropertiesController(MetaObject object, String fileNameSlot, String fileSizeSlot, String fileContentTypeSlot) {
            this.object = object;
            this.fileNameSlot = fileNameSlot;
            this.fileSizeSlot = fileSizeSlot;
            this.fileContentTypeSlot = fileContentTypeSlot;
        }

        @Override
        public void execute(IViewState viewState) {
            HtmlSimpleValueComponent component = (HtmlSimpleValueComponent)this.getControlledComponent();
            String name = component.getName();
            UploadedFile file = RenderersRequestProcessorImpl.getUploadedFile(name);
            if (file != null) {
                Object object = this.object.getObject();
                try {
                    String currentEncoding = RenderersRequestProcessorImpl.getCurrentEncoding();
                    this.setPropertyIgnoringErrors(object, this.fileNameSlot, currentEncoding != null ? new String(file.getName().getBytes(), currentEncoding) : new String(file.getName().getBytes()));
                }
                catch (UnsupportedEncodingException e) {
                    this.setPropertyIgnoringErrors(object, this.fileNameSlot, file.getName());
                    e.printStackTrace();
                }
                this.setPropertyIgnoringErrors(object, this.fileSizeSlot, file.getSize());
                this.setPropertyIgnoringErrors(object, this.fileContentTypeSlot, file.getContentType());
            }
        }

        private void setPropertyIgnoringErrors(Object object, String property, Object value) {
            if (property == null) {
                return;
            }
            try {
                PropertyUtils.setProperty((Object)object, (String)property, (Object)value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

