/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import com.google.common.base.Strings;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlMenu;
import pt.ist.fenixWebFramework.renderers.components.HtmlMenuOption;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaSlotKey;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class BooleanMenuInputRenderer
extends InputRenderer {
    private String nullOptionKey;
    private String bundle;

    public String getNullOptionKey() {
        return this.nullOptionKey;
    }

    public void setNullOptionKey(String nullOptionKey) {
        this.nullOptionKey = nullOptionKey;
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            @Override
            public HtmlComponent createComponent(Object object, Class type) {
                HtmlMenu menu = new HtmlMenu();
                if (BooleanMenuInputRenderer.this.getNullOptionKey() != null) {
                    String defaultOptionTitle = RenderUtils.getResourceString(BooleanMenuInputRenderer.this.getBundle(), BooleanMenuInputRenderer.this.getNullOptionKey());
                    menu.createDefaultOption(defaultOptionTitle).setSelected(object == null);
                    menu.setConverter(new Converter(){

                        @Override
                        public Object convert(Class type, Object value) {
                            return Strings.isNullOrEmpty((String)((String)value)) ? null : Boolean.valueOf((String)value);
                        }
                    });
                }
                HtmlMenuOption trueOption = menu.createOption(RenderUtils.getResourceString("TRUE"));
                HtmlMenuOption falseOption = menu.createOption(RenderUtils.getResourceString("FALSE"));
                trueOption.setValue("true");
                falseOption.setValue("false");
                if (object != null) {
                    ((Boolean)object != false ? trueOption : falseOption).setSelected(true);
                }
                menu.setTargetSlot((MetaSlotKey)BooleanMenuInputRenderer.this.getInputContext().getMetaObject().getKey());
                return menu;
            }
        };
    }
}

