/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions.validators;

import com.google.common.base.Strings;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;

public class NumberRangeValidator
extends HtmlValidator {
    private boolean isNumber;
    private Integer upperBound = null;
    private Integer lowerBound = null;

    public NumberRangeValidator() {
    }

    public NumberRangeValidator(HtmlChainValidator htmlChainValidator) {
        super(htmlChainValidator);
    }

    public Integer getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(Integer lowerBound) {
        this.lowerBound = lowerBound;
    }

    public Integer getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(Integer upperBound) {
        this.upperBound = upperBound;
    }

    @Override
    public void performValidation() {
        String numberText = this.getComponent().getValue();
        if (!Strings.isNullOrEmpty((String)numberText)) {
            try {
                int number = Integer.parseInt(numberText.trim());
                boolean inRange = true;
                this.isNumber = true;
                if (this.lowerBound != null) {
                    inRange &= this.lowerBound <= number;
                }
                if (this.upperBound != null) {
                    inRange &= this.upperBound >= number;
                }
                this.setValid(inRange);
            }
            catch (NumberFormatException e) {
                this.isNumber = false;
                this.setValid(false);
            }
        }
    }

    @Override
    public String getErrorMessage() {
        if (!this.isNumber) {
            return RenderUtils.getResourceString("renderers.validator.number.integer");
        }
        if (this.lowerBound != null && this.upperBound != null) {
            return RenderUtils.getFormatedResourceString("renderers.validator.number.range.both", this.lowerBound, this.upperBound);
        }
        if (this.lowerBound != null) {
            return RenderUtils.getFormatedResourceString("renderers.validator.number.range.lower", this.lowerBound);
        }
        return RenderUtils.getFormatedResourceString("renderers.validator.number.range.upper", this.upperBound);
    }

    @Override
    public boolean hasJavascriptSupport() {
        return true;
    }

    @Override
    protected String getSpecificValidatorScript() {
        return "function(element) { var text = $(element).attr('value'); var lb = " + this.getLowerBound() + "; var ub = " + this.getUpperBound() + ";return text.length == 0 || ((lb == null || (lb != null && parseInt(text) >= lb)) && (ub == null || (ub != null && parseInt(text) <= ub))); }";
    }

    @Override
    protected String getJavascriptErrorMessage() {
        if (this.lowerBound != null && this.upperBound != null) {
            return RenderUtils.getFormatedResourceString("renderers.validator.number.range.both", this.lowerBound, this.upperBound);
        }
        if (this.lowerBound != null) {
            return RenderUtils.getFormatedResourceString("renderers.validator.number.range.lower", this.lowerBound);
        }
        return RenderUtils.getFormatedResourceString("renderers.validator.number.range.upper", this.upperBound);
    }
}

