/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions.validators;

import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;

public class LongRangeValidator
extends HtmlValidator {
    private boolean isNumber;
    private Long upperBound = null;
    private Long lowerBound = null;

    public LongRangeValidator() {
    }

    public LongRangeValidator(HtmlChainValidator htmlChainValidator) {
        super(htmlChainValidator);
    }

    public long getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(long lowerBound) {
        this.lowerBound = lowerBound;
    }

    public long getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(long upperBound) {
        this.upperBound = upperBound;
    }

    @Override
    public void performValidation() {
        try {
            long number = Long.parseLong(this.getComponent().getValue().trim());
            boolean inRange = true;
            this.isNumber = true;
            if (this.lowerBound != null) {
                inRange &= this.lowerBound <= number;
            }
            if (this.upperBound != null) {
                inRange &= this.upperBound >= number;
            }
            this.setValid(inRange);
        }
        catch (NumberFormatException e) {
            this.isNumber = false;
            this.setValid(false);
        }
    }

    @Override
    public String getErrorMessage() {
        if (!this.isNumber) {
            return RenderUtils.getResourceString("renderers.validator.number");
        }
        if (this.lowerBound != null && this.upperBound != null) {
            return RenderUtils.getFormatedResourceString("renderers.validator.number.range.both", this.lowerBound, this.upperBound);
        }
        if (this.lowerBound != null) {
            return RenderUtils.getFormatedResourceString("renderers.validator.number.range.lower", this.lowerBound);
        }
        return RenderUtils.getFormatedResourceString("renderers.validator.number.range.upper", this.upperBound);
    }
}

