/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions.validators;

import com.google.common.base.Strings;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import pt.ist.fenixWebFramework.renderers.components.HtmlSimpleValueComponent;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;

public class LocalizedStringValidator
extends HtmlValidator {
    public LocalizedStringValidator() {
    }

    public LocalizedStringValidator(HtmlChainValidator htmlChainValidator) {
        super(htmlChainValidator);
    }

    @Override
    public void performValidation() {
        HtmlSimpleValueComponent component = (HtmlSimpleValueComponent)this.getComponent();
        if (Strings.isNullOrEmpty((String)component.getValue())) {
            this.setValid(true);
            return;
        }
        try {
            new JsonParser().parse(component.getValue()).getAsJsonObject();
            this.setValid(true);
        }
        catch (JsonSyntaxException | IllegalStateException e) {
            this.setValid(false);
            this.setMessage("renderers.validator.invalid.json");
        }
    }
}

