/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions.factories;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.beanutils.PropertyUtils;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.rendererExtensions.factories.DomainMetaObject$callable$callService;
import pt.ist.fenixWebFramework.rendererExtensions.util.ObjectChange;
import pt.ist.fenixWebFramework.rendererExtensions.util.ObjectKey;
import pt.ist.fenixWebFramework.renderers.model.CompositeSlotSetter;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectKey;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixWebFramework.renderers.model.SimpleMetaObject;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;
import pt.ist.fenixframework.core.WriteOnReadError;

public class DomainMetaObject
extends SimpleMetaObject {
    private String externalId;
    private transient DomainObject object;
    public static final Advice advice$callService = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected DomainMetaObject() {
        super(null);
    }

    public DomainMetaObject(DomainObject object) {
        this();
        this.setObject(object);
    }

    @Override
    public Object getObject() {
        if (this.object == null) {
            this.object = this.getPersistentObject();
        }
        return this.object;
    }

    @Override
    protected void setObject(Object object) {
        this.object = (DomainObject)object;
        if (this.object != null) {
            this.externalId = this.object.getExternalId();
        }
    }

    protected DomainObject getPersistentObject() {
        return FenixFramework.getDomainObject((String)this.externalId);
    }

    public String getExternalId() {
        return this.externalId;
    }

    protected void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @Override
    public Class getType() {
        return this.getObject().getClass();
    }

    @Override
    public MetaObjectKey getKey() {
        return new MetaObjectKey(this.getType(), this.getExternalId());
    }

    @Override
    protected void commit() {
        ArrayList<ObjectChange> changes = new ArrayList<ObjectChange>();
        ObjectKey key = new ObjectKey(this.getExternalId(), this.getType());
        for (MetaSlot slot : this.getAllSlots()) {
            if (slot.isSetterIgnored() || !slot.isCached()) continue;
            Object change = slot.getObject();
            ObjectChange objectChange = new ObjectChange(key, slot.getName(), change);
            changes.add(objectChange);
        }
        for (CompositeSlotSetter compositeSetter : this.getCompositeSetters()) {
            try {
                changes.add(new ObjectChange(key, compositeSetter.getSetter(this.getType()), compositeSetter.getArgumentValues()));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("could not find specialized setter", e);
            }
        }
        this.callService(changes);
    }

    protected ServicePredicateWithResult getServiceToCall(List<ObjectChange> changes) {
        return new ServicePredicateWithResult(changes);
    }

    protected Object callService(List<ObjectChange> list) {
        return advice$callService.perform((Callable)new DomainMetaObject$callable$callService(this, list));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    protected static /* synthetic */ Object advised$callService(DomainMetaObject this_, List changes) {
        return this_.getServiceToCall(changes).execute();
    }

    public static class ServicePredicateWithResult {
        final List<ObjectChange> changes;
        Object result = null;

        public ServicePredicateWithResult(List<ObjectChange> changes) {
            this.changes = changes;
        }

        public Object execute() {
            Hashtable<ObjectKey, Object> objects = new Hashtable<ObjectKey, Object>();
            for (ObjectChange change : this.changes) {
                try {
                    Object object = this.getObject(objects, change);
                    this.processChange(change, object);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() != null && e.getCause() instanceof WriteOnReadError) {
                        throw (WriteOnReadError)e.getCause();
                    }
                    if (e.getCause() == null || !(e.getCause() instanceof RuntimeException)) continue;
                    throw (RuntimeException)e.getCause();
                }
                catch (IllegalAccessException e) {
                    throw new Error(e);
                }
                catch (NoSuchMethodException e) {
                    throw new Error(e);
                }
                catch (InstantiationException e) {
                    throw new Error(e);
                }
            }
            return objects.values();
        }

        protected void processChange(ObjectChange change, Object object) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
            if (change.slot != null) {
                this.setProperty(object, change.slot, change.value);
            } else if (change.setter != null) {
                this.invokeSetter(object, change.setter, change.values);
            }
        }

        private void invokeSetter(Object object, Method setter, Object[] values) {
            try {
                setter.invoke(object, values);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() != null && e.getCause() instanceof WriteOnReadError) {
                    throw (WriteOnReadError)e.getCause();
                }
                if (e.getCause() != null && e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException("error while invoking specialized setter", e.getTargetException());
            }
            catch (Exception e) {
                throw new RuntimeException("error while invoking specialized setter", e);
            }
        }

        protected void setProperty(Object object, String slot, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
            Class type = this.getSlotType(object, slot);
            if (type == null) {
                throw new RuntimeException("could not find type of property " + slot + " in object " + object);
            }
            if (Collection.class.isAssignableFrom(type)) {
                this.setCollectionProperty(object, slot, (Collection)value);
            } else {
                try {
                    this.setSlotProperty(object, slot, value);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("the value '" + value + "' given for slot '" + slot + "' does not match slot's type '" + type + "'");
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("could not access to the slot '" + slot + "' of object '" + object + "', probably is not public");
                }
            }
        }

        protected Class getSlotType(Object object, String slot) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            return PropertyUtils.getPropertyType((Object)object, (String)slot);
        }

        protected void setSlotProperty(Object object, String slot, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
            PropertyUtils.setProperty((Object)object, (String)slot, (Object)value);
        }

        protected void setCollectionProperty(Object object, String slot, Collection list) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
            ArrayList relation = (ArrayList)this.getSlotProperty(object, slot);
            if (relation == null || this.isWriteableSlot(object, slot)) {
                relation = new ArrayList();
                relation.addAll(list);
                this.setSlotProperty(object, slot, relation);
            } else {
                relation.clear();
                relation.addAll(list);
            }
        }

        protected boolean isWriteableSlot(Object object, String slot) {
            return PropertyUtils.isWriteable((Object)object, (String)slot);
        }

        protected Object getSlotProperty(Object object, String slot) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
            return PropertyUtils.getProperty((Object)object, (String)slot);
        }

        private Object getObject(Hashtable<ObjectKey, Object> objects, ObjectChange change) {
            Object object = objects.get(change.key);
            if (object == null) {
                object = this.getNewObject(change);
                objects.put(change.key, object);
            }
            return object;
        }

        protected DomainObject getNewObject(ObjectChange change) {
            return FenixFramework.getDomainObject((String)change.key.getExternalId());
        }
    }
}

