/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import pt.ist.fenixframework.DomainObject;

public class PageContainerBean
implements Serializable {
    private transient List<? extends DomainObject> objects;
    private List<DomainObject> pageObjects;
    private DomainObject selected;
    private Integer numberOfPages;
    private Integer page = 1;

    public List<? extends DomainObject> getObjects() {
        return this.objects;
    }

    public void setObjects(List<? extends DomainObject> objects) {
        this.objects = objects;
        this.setPageObjects(null);
    }

    public List<DomainObject> getPageObjects() {
        if (this.pageObjects != null) {
            ArrayList<DomainObject> result = new ArrayList<DomainObject>();
            for (DomainObject domainObject : this.pageObjects) {
                result.add(domainObject);
            }
            return result;
        }
        return null;
    }

    public void setPageObjects(List<? extends DomainObject> pageObjects) {
        if (pageObjects != null) {
            this.pageObjects = new ArrayList<DomainObject>();
            for (DomainObject domainObject : pageObjects) {
                this.pageObjects.add(domainObject);
            }
        } else {
            this.pageObjects = null;
        }
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public DomainObject getSelected() {
        return this.selected;
    }

    public void setSelected(DomainObject selected) {
        this.selected = selected;
    }

    public List<DomainObject> getPageByPageSize(int pageSize) {
        if (this.getPageObjects() != null) {
            return this.getPageObjects();
        }
        if (this.getObjects() != null && !this.getObjects().isEmpty()) {
            this.validatePageNumber(pageSize);
            int from = (this.getPage() - 1) * pageSize;
            int to = this.getObjects().size() > this.getPage() * pageSize ? this.getPage() * pageSize : this.getObjects().size();
            ArrayList<DomainObject> subList = new ArrayList<DomainObject>(this.getObjects().subList(from, to));
            this.setPageObjects(subList);
            return subList;
        }
        return Collections.emptyList();
    }

    private void validatePageNumber(int pageSize) {
        if (this.getPage() < 1) {
            this.setPage(1);
        } else {
            Integer numberOfPages = this.getNumberOfPages(pageSize);
            if (this.getPage() > numberOfPages) {
                this.setPage(numberOfPages);
            }
        }
    }

    public int getNumberOfPages(int pageSize) {
        if (this.getObjects() != null) {
            this.numberOfPages = (int)Math.ceil((double)this.getObjects().size() / (double)pageSize);
        }
        return this.numberOfPages;
    }

    public boolean hasNextPage(int pageSize) {
        return this.getPage() < this.getNumberOfPages(pageSize);
    }

    public boolean hasPreviousPage(int pageSize) {
        return this.getPage() > 1;
    }

    public List<? extends DomainObject> getAllObjects() {
        if (this.getPageObjects() != null) {
            return this.getPageObjects();
        }
        if (this.getObjects() != null) {
            this.setPageObjects(this.getObjects());
            return this.getObjects();
        }
        return Collections.emptyList();
    }

    public void setPageJump(Integer pageJump) {
        this.setPage(pageJump);
    }

    public Integer getPageJump() {
        return null;
    }
}

