/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collections;
import java.util.Properties;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.fenixWebFramework.rendererExtensions.validators.LocalizedStringValidator;
import pt.ist.fenixWebFramework.rendererExtensions.validators.RequiredLocalizedStringValidator;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlSimpleValueComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlTextInput;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixWebFramework.renderers.validators.ValidatorProperties;

public class LocalizedStringInputRenderer
extends InputRenderer {
    private String eachClasses;

    public String getEachClasses() {
        return this.eachClasses;
    }

    public void setEachClasses(String eachClasses) {
        this.eachClasses = eachClasses;
    }

    protected Converter getConverter() {
        return new LocalizedStringConverter();
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        MetaSlot metaSlot;
        MetaObject metaObject = this.getInputContext().getMetaObject();
        if (metaObject != null && metaObject instanceof MetaSlot && !(metaSlot = (MetaSlot)metaObject).hasValidator()) {
            Class<LocalizedStringValidator> defaultValidator = LocalizedStringValidator.class;
            metaSlot.setValidators(Collections.singletonList(new ValidatorProperties(defaultValidator, new Properties())));
        }
        return new MultiLanguageStringInputLayout();
    }

    protected HtmlSimpleValueComponent getInputComponent() {
        return new HtmlTextInput();
    }

    protected LocalizedString getLocalized(Object object) {
        if (object instanceof LocalizedString) {
            return (LocalizedString)object;
        }
        return null;
    }

    public static class LocalizedStringConverter
    extends Converter {
        @Override
        public Object convert(Class type, Object value) {
            String text = (String)value;
            return Strings.isNullOrEmpty((String)text) ? null : this.processLocalized(LocalizedString.fromJson((JsonElement)new JsonParser().parse(text)));
        }

        protected Object processLocalized(LocalizedString mls) {
            return mls;
        }
    }

    protected class MultiLanguageStringInputLayout
    extends Layout {
        protected MultiLanguageStringInputLayout() {
        }

        @Override
        public HtmlComponent createComponent(Object object, Class type) {
            LocalizedString localized = LocalizedStringInputRenderer.this.getLocalized(object);
            MetaSlot slot = (MetaSlot)LocalizedStringInputRenderer.this.getInputContext().getMetaObject();
            HtmlSimpleValueComponent input = LocalizedStringInputRenderer.this.getInputComponent();
            input.setValue(localized == null ? "" : localized.json().toString());
            input.setAttribute("bennu-localized-string", "");
            input.setTargetSlot(slot.getKey());
            input.setConverter(LocalizedStringInputRenderer.this.getConverter());
            if (slot.isRequired() || slot.getValidators().stream().filter(prop -> RequiredLocalizedStringValidator.class.isAssignableFrom(prop.getType())).findAny().isPresent()) {
                input.setAttribute("required-any", "");
            }
            LocalizedStringInputRenderer.this.getInputContext().requireToolkit();
            return input;
        }
    }
}

