/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions;

import org.apache.commons.beanutils.BeanUtils;
import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlLink;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;

public class EmailIdentityRenderer
extends OutputRenderer {
    private boolean collapsed = true;
    private String text;
    private String address;

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            @Override
            public HtmlComponent createComponent(Object object, Class type) {
                if (object == null) {
                    return new HtmlText();
                }
                String email = null;
                String name = null;
                try {
                    email = BeanUtils.getProperty((Object)object, (String)EmailIdentityRenderer.this.getAddress());
                    name = BeanUtils.getProperty((Object)object, (String)EmailIdentityRenderer.this.getText());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                HtmlText nameHtml = new HtmlText(name);
                HtmlLink emailHtml = new HtmlLink();
                emailHtml.setContextRelative(false);
                emailHtml.setUrl("mailto:" + email);
                if (!EmailIdentityRenderer.this.isCollapsed()) {
                    emailHtml.setText(email);
                    HtmlInlineContainer container = new HtmlInlineContainer();
                    container.addChild(nameHtml);
                    container.addChild(new HtmlText(" <", true));
                    container.addChild(emailHtml);
                    container.addChild(new HtmlText(">", true));
                    container.setIndented(false);
                    return container;
                }
                emailHtml.setText(name);
                return emailHtml;
            }
        };
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }
}

