/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions;

import pt.ist.fenixWebFramework.renderers.StringInputRenderer;
import pt.ist.fenixWebFramework.renderers.TextFieldRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlLink;
import pt.ist.fenixWebFramework.renderers.components.HtmlScript;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.HtmlTextInput;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaSlotKey;

public class ColorInputRenderer
extends StringInputRenderer {
    private static final String BASE_PATH = "/javaScript/picker";

    @Override
    protected HtmlComponent createTextField(Object object, Class type) {
        HtmlContainer fieldComponent = (HtmlContainer)super.createTextField(object, type);
        HtmlTextInput input = (HtmlTextInput)fieldComponent.getChildren().get(0);
        input.setId(this.getContext().getMetaObject().getKey().toString());
        HtmlLink link = new HtmlLink();
        link.setModuleRelative(false);
        link.setUrl("/javaScript/picker/img/");
        HtmlScript script = new HtmlScript();
        script.setContentType("text/javascript");
        script.setScript(String.format("new Control.ColorPicker('%s', { IMAGE_BASE : '%s' });", input.getId(), link.calculateUrl()));
        HtmlInlineContainer container = new HtmlInlineContainer();
        container.addChild(input);
        container.addChild(new HtmlText(this.getFormatLabel()));
        container.addChild(script);
        return container;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new ColorPickerLayout();
    }

    class ColorPickerLayout
    extends TextFieldRenderer.TextFieldLayout {
        ColorPickerLayout() {
            super(ColorInputRenderer.this);
        }

        @Override
        protected void setContextSlot(HtmlComponent component, MetaSlotKey slotKey) {
            HtmlContainer container = (HtmlContainer)component;
            super.setContextSlot(container.getChildren().get(0), slotKey);
        }

        @Override
        public void applyStyle(HtmlComponent component) {
            HtmlContainer container = (HtmlContainer)component;
            super.applyStyle(container.getChildren().get(0));
        }
    }
}

