/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.function.Function;
import org.apache.commons.beanutils.PropertyUtils;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlHiddenField;
import pt.ist.fenixWebFramework.renderers.components.HtmlLink;
import pt.ist.fenixWebFramework.renderers.components.HtmlScript;
import pt.ist.fenixWebFramework.renderers.components.HtmlSimpleValueComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.HtmlTextInput;
import pt.ist.fenixWebFramework.renderers.components.controllers.HtmlController;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixWebFramework.renderers.model.MetaSlotKey;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.utils.RendererPropertyUtils;
import pt.ist.fenixWebFramework.servlets.filters.contentRewrite.GenericChecksumRewriter;

public class AutoCompleteInputRenderer
extends InputRenderer {
    public static final String SERVLET_URI = "/ajax/AutoCompleteServlet";
    public static final String TYPING_VALUE = "custom";
    private String rawSlotName;
    private String valueField;
    private String labelField;
    private String format;
    private String args;
    private Integer maxCount;
    private String size;
    private int minChars;
    private String autoCompleteStyleClass;
    private String autoCompleteItemsStyleClass;
    private String textFieldStyleClass;
    private String errorStyleClass;
    private String autoCompleteWidth;
    private String provider;

    public AutoCompleteInputRenderer() {
        this.setMinChars(3);
    }

    public String getAutoCompleteWidth() {
        return this.autoCompleteWidth;
    }

    public void setAutoCompleteWidth(String autoCompleteWidth) {
        this.autoCompleteWidth = autoCompleteWidth;
    }

    public String getRawSlotName() {
        return this.rawSlotName;
    }

    public void setValueField(String valueField) {
        this.valueField = valueField;
    }

    public String getValueField() {
        return this.valueField;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public String getArgs() {
        return this.args;
    }

    public void setRawSlotName(String rawSlotName) {
        this.rawSlotName = rawSlotName;
    }

    public String getLabelField() {
        return this.labelField;
    }

    public void setLabelField(String labelField) {
        this.labelField = labelField;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Integer getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(Integer maxCount) {
        this.maxCount = maxCount;
    }

    public String getAutoCompleteItemsStyleClass() {
        return this.autoCompleteItemsStyleClass;
    }

    public void setAutoCompleteItemsStyleClass(String autoCompleteItemsStyleClass) {
        this.autoCompleteItemsStyleClass = autoCompleteItemsStyleClass;
    }

    public String getAutoCompleteStyleClass() {
        return this.autoCompleteStyleClass;
    }

    public void setAutoCompleteStyleClass(String autoCompleteStyleClass) {
        this.autoCompleteStyleClass = autoCompleteStyleClass;
    }

    public String getTextFieldStyleClass() {
        return this.textFieldStyleClass;
    }

    public void setTextFieldStyleClass(String textFieldStyleClass) {
        this.textFieldStyleClass = textFieldStyleClass;
    }

    public String getErrorStyleClass() {
        return this.errorStyleClass;
    }

    public void setErrorStyleClass(String errorStyleClass) {
        this.errorStyleClass = errorStyleClass;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public int getMinChars() {
        return this.minChars;
    }

    public void setMinChars(int minChars) {
        this.minChars = minChars;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new AutoCompleteLayout();
    }

    protected Converter createConverter() {
        return new AutoCompleteConverter();
    }

    protected static class AutoCompleteConverter
    extends Converter {
        @Override
        public Object convert(Class type, Object value) {
            if (value == null || "".equals(value)) {
                return null;
            }
            String text = (String)value;
            if (text.equals(AutoCompleteInputRenderer.TYPING_VALUE)) {
                return null;
            }
            String key = text;
            return new DomainObjectKeyConverter().convert(type, key);
        }
    }

    protected static class UpdateRawNameController
    extends HtmlController {
        private final String rawSlotName;

        public UpdateRawNameController(String rawSlotName) {
            this.rawSlotName = rawSlotName;
        }

        @Override
        public void execute(IViewState viewState) {
            HtmlSimpleValueComponent component = (HtmlSimpleValueComponent)this.getControlledComponent();
            this.updatRawSlot(viewState, component.getValue());
        }

        private void updatRawSlot(IViewState viewState, String value) {
            Object object = viewState.getMetaObject().getObject();
            try {
                PropertyUtils.setProperty((Object)object, (String)this.rawSlotName, (Object)value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected class AutoCompleteLayout
    extends Layout {
        @Override
        public HtmlComponent createComponent(Object object, Class type) {
            Object beanObject;
            HtmlBlockContainer container = new HtmlBlockContainer();
            this.addScripts(container);
            MetaSlotKey key = (MetaSlotKey)AutoCompleteInputRenderer.this.getContext().getMetaObject().getKey();
            HtmlHiddenField valueField = new HtmlHiddenField();
            valueField.setTargetSlot(key);
            valueField.setId(key.toString() + "_AutoComplete");
            valueField.setName(valueField.getId());
            container.addChild(valueField);
            if (object != null) {
                Object oid = RendererPropertyUtils.getProperty(object, AutoCompleteInputRenderer.this.getValueField(), false);
                valueField.setValue(oid == null ? null : oid.toString());
            }
            valueField.setConverter(AutoCompleteInputRenderer.this.createConverter());
            HtmlHiddenField oldValueField = new HtmlHiddenField();
            oldValueField.setId(key.toString() + "_OldValue");
            oldValueField.setName(oldValueField.getId());
            container.addChild(oldValueField);
            HtmlTextInput textField = new HtmlTextInput();
            textField.setId(key.toString());
            textField.setName(textField.getId());
            textField.setClasses(AutoCompleteInputRenderer.this.getTextFieldStyleClass());
            textField.setSize(AutoCompleteInputRenderer.this.getSize());
            textField.setAttribute("autocomplete", "off");
            container.addChild(textField);
            if (object != null && AutoCompleteInputRenderer.this.getLabelField() != null) {
                String label = (String)RendererPropertyUtils.getProperty(object, AutoCompleteInputRenderer.this.getLabelField(), false);
                textField.setValue(label);
            } else if (AutoCompleteInputRenderer.this.getRawSlotName() != null && (beanObject = AutoCompleteInputRenderer.this.getInputContext().getParentContext().getMetaObject().getObject()) != null) {
                String rawText = (String)RendererPropertyUtils.getProperty(beanObject, AutoCompleteInputRenderer.this.getRawSlotName(), false);
                textField.setValue(rawText);
                if (rawText != null) {
                    valueField.setValue(AutoCompleteInputRenderer.TYPING_VALUE);
                }
            }
            if (AutoCompleteInputRenderer.this.getRawSlotName() != null) {
                textField.setController(new UpdateRawNameController(AutoCompleteInputRenderer.this.getRawSlotName()));
            }
            HtmlText errorMessage = new HtmlText(RenderUtils.getResourceString("fenix.renderers.autocomplete.error"));
            errorMessage.setId(key.toString() + "_Error");
            errorMessage.setClasses(AutoCompleteInputRenderer.this.getErrorStyleClass());
            errorMessage.setStyle("display: none;");
            container.addChild(errorMessage);
            this.addFinalScript(container, textField.getId());
            return container;
        }

        protected void addScripts(HtmlContainer container) {
            String[] scriptNames;
            HtmlLink link = new HtmlLink();
            link.setModuleRelative(false);
            link.setContextRelative(true);
            for (String script : scriptNames = new String[]{"autoComplete.js", "autoCompleteHandlers.js"}) {
                this.addSingleScript(container, link, script);
            }
        }

        protected void addSingleScript(HtmlContainer container, HtmlLink link, String scriptName) {
            link.setUrl("/bennu-renderers/js/" + scriptName);
            HtmlScript script = new HtmlScript("text/javascript", link.calculateUrl(), true);
            container.addChild(script);
        }

        private HtmlLink getAutoCompleteLink(Function<String, String> encoder) {
            HtmlLink link = new HtmlLink();
            link.setModuleRelative(false);
            link.setContextRelative(true);
            link.setUrl(AutoCompleteInputRenderer.SERVLET_URI);
            link.setParameter("args", encoder.apply(this.getFormatedArgs()));
            if (AutoCompleteInputRenderer.this.getLabelField() != null) {
                link.setParameter("labelField", AutoCompleteInputRenderer.this.getLabelField());
            }
            link.setParameter("valueField", AutoCompleteInputRenderer.this.getValueField());
            link.setParameter("styleClass", AutoCompleteInputRenderer.this.getAutoCompleteItemsStyleClass() == null ? "" : AutoCompleteInputRenderer.this.getAutoCompleteItemsStyleClass());
            link.setEscapeAmpersand(false);
            if (AutoCompleteInputRenderer.this.getFormat() != null) {
                link.setParameter("format", encoder.apply(AutoCompleteInputRenderer.this.getFormat()));
            }
            if (AutoCompleteInputRenderer.this.getMaxCount() != null) {
                link.setParameter("maxCount", String.valueOf(AutoCompleteInputRenderer.this.getMaxCount()));
            }
            return link;
        }

        protected void addFinalScript(HtmlContainer container, String textFieldId) {
            HtmlLink link = this.getAutoCompleteLink(s -> s);
            String linkWithouthChechsum = link.calculateUrl();
            String linkWithChecksum = this.calculateUriWithChecksum(link);
            String finalUri = this.getAutoCompleteLink(s -> this.encode((String)s)).calculateUrl() + linkWithChecksum.substring(linkWithouthChechsum.length());
            String escapeId = this.escapeId(textFieldId);
            Object scriptText = "jQuery(\"input#" + escapeId + "\").autocomplete(\"" + finalUri + "\", { minChars: " + AutoCompleteInputRenderer.this.getMinChars() + (String)(!Strings.isNullOrEmpty((String)AutoCompleteInputRenderer.this.getAutoCompleteWidth()) ? ", width: '" + AutoCompleteInputRenderer.this.getAutoCompleteWidth() + "'" : "") + ", validSelection: false, cleanSelection: clearAutoComplete, select: selectElement, after: updateCustomValue, error:showError}); +\njQuery(\"input[name='" + escapeId + "']\").val(jQuery(\"input#" + escapeId + "\").val());";
            if (AutoCompleteInputRenderer.this.getRawSlotName() != null) {
                scriptText = ((String)scriptText).concat("\njQuery(\"input[name='" + escapeId + "']\").closest('form').submit(function() {\nvar inputFieldVal = jQuery(\"input[name='" + escapeId + "_text']\").val()\nupdateRawSlotNameOnSubmit(jQuery(\"input[name='" + escapeId + "_text']\"),inputFieldVal);});");
            }
            HtmlScript script = new HtmlScript();
            script.setContentType("text/javascript");
            script.setScript((CharSequence)scriptText);
            container.addChild(script);
        }

        private String encode(String string) {
            try {
                return URLEncoder.encode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
        }

        private String calculateUriWithChecksum(HtmlLink link) {
            String calculatedUrl = link.calculateUrl();
            Object checkSumString = "";
            checkSumString = (String)checkSumString + link.getParameter("maxCount");
            checkSumString = (String)checkSumString + link.getParameter("labelField");
            checkSumString = (String)checkSumString + link.getParameter("format");
            checkSumString = (String)checkSumString + link.getParameter("valueField");
            checkSumString = (String)checkSumString + link.getParameter("styleClass");
            String urlParametersBoundaryCharacter = "&";
            if (calculatedUrl.indexOf("?") == -1) {
                urlParametersBoundaryCharacter = "?";
            }
            return calculatedUrl + String.format(urlParametersBoundaryCharacter + "%s=%s", "_request_checksum_", GenericChecksumRewriter.calculateChecksum((String)checkSumString, AutoCompleteInputRenderer.this.getContext().getViewState().getRequest().getSession(false)));
        }

        protected String escapeId(String textFieldId) {
            return textFieldId.replace(".", "\\\\.").replaceAll(":", "\\\\\\\\:");
        }

        protected String getFormatedArgs() {
            Object object = ((MetaSlot)AutoCompleteInputRenderer.this.getInputContext().getMetaObject()).getMetaObject().getObject();
            if (AutoCompleteInputRenderer.this.getProvider() == null) {
                return RenderUtils.getFormattedProperties(AutoCompleteInputRenderer.this.getArgs(), object);
            }
            return String.format("provider=%s,%s", AutoCompleteInputRenderer.this.getProvider(), RenderUtils.getFormattedProperties(AutoCompleteInputRenderer.this.getArgs(), object));
        }
    }
}

