/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.servlets.filters.contentRewrite;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import pt.ist.fenixWebFramework.RenderersConfigurationManager;
import pt.ist.fenixWebFramework.servlets.filters.contentRewrite.GenericChecksumRewriter;
import pt.ist.fenixWebFramework.servlets.filters.contentRewrite.ResponseWrapper;

public class RequestChecksumFilter
implements Filter {
    private static final String ENCODING = Charsets.UTF_8.name();
    public static Set<ChecksumPredicate> predicates = new HashSet<ChecksumPredicate>();

    public static void registerFilterRule(ChecksumPredicate predicate) {
        predicates.add(predicate);
    }

    public void init(FilterConfig config) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (RenderersConfigurationManager.getConfiguration().filterRequestWithDigest().booleanValue() && this.shouldValidateChecksum(request) && !this.isValidChecksum(request)) {
            this.handleInvalidChecksum(request, (HttpServletResponse)servletResponse);
            return;
        }
        ResponseWrapper responseWrapper = new ResponseWrapper((HttpServletResponse)servletResponse);
        filterChain.doFilter(servletRequest, (ServletResponse)responseWrapper);
        responseWrapper.writeRealResponse(request.getSession(false));
    }

    protected void handleInvalidChecksum(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null) {
            httpSession.invalidate();
        }
        response.sendRedirect(RenderersConfigurationManager.getConfiguration().tamperingRedirect());
    }

    protected boolean shouldValidateChecksum(HttpServletRequest httpServletRequest) {
        for (ChecksumPredicate predicate : predicates) {
            if (predicate.shouldFilter(httpServletRequest)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidChecksum(HttpServletRequest httpServletRequest) {
        String checksum = httpServletRequest.getParameter("_request_checksum_");
        if (checksum == null || checksum.length() == 0) {
            checksum = (String)httpServletRequest.getAttribute("_request_checksum_");
        }
        return this.isValidChecksum(httpServletRequest, checksum);
    }

    public static String decodeURL(String url, String encoding) {
        if (url == null) {
            return null;
        }
        try {
            return URLDecoder.decode(url, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    private boolean isValidChecksum(HttpServletRequest httpServletRequest, String checksum) {
        HttpSession session = httpServletRequest.getSession(false);
        String uri = RequestChecksumFilter.decodeURL(httpServletRequest.getRequestURI(), ENCODING);
        return this.isValidChecksum(uri, RequestChecksumFilter.decodeURL(httpServletRequest.getQueryString(), ENCODING), checksum, session) || this.isValidChecksum(uri, httpServletRequest.getQueryString(), checksum, session);
    }

    private boolean isValidChecksum(String uri, String queryString, String checksum, HttpSession session) {
        String request = queryString != null ? uri + "?" + queryString : uri;
        return checksum != null && checksum.length() > 0 && checksum.equals(GenericChecksumRewriter.calculateChecksum(request, session));
    }

    public static interface ChecksumPredicate {
        public boolean shouldFilter(HttpServletRequest var1);
    }
}

