/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.servlets.filters.contentRewrite;

import java.io.Serializable;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.UserAuthenticationListener;

public class RenderersSessionSecret {
    private static final String RENDERERS_SESSION_SECRET = "RENDERERS_SESSION_SECRET";

    static String computeSecretFromSession(HttpSession session) {
        if (session != null) {
            SessionSecretWrapper secret = (SessionSecretWrapper)session.getAttribute(RENDERERS_SESSION_SECRET);
            if (secret != null) {
                return secret.secret;
            }
            return null;
        }
        return null;
    }

    public static final class RenderersUserAuthenticationListener
    implements UserAuthenticationListener {
        public void onLogin(HttpServletRequest request, HttpServletResponse response, User user) {
            SessionSecretWrapper secret = new SessionSecretWrapper(user.getUsername() + UUID.randomUUID().toString());
            HttpSession session = request.getSession();
            session.setAttribute(RenderersSessionSecret.RENDERERS_SESSION_SECRET, (Object)secret);
        }

        public void onLogout(HttpServletRequest request, HttpServletResponse response, User user) {
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.removeAttribute(RenderersSessionSecret.RENDERERS_SESSION_SECRET);
            }
        }
    }

    private static final class SessionSecretWrapper
    implements Serializable {
        private static final long serialVersionUID = 828957763368790412L;
        private final String secret;

        SessionSecretWrapper(String secret) {
            this.secret = secret;
        }

        public String toString() {
            return "!!HIDDEN!!";
        }
    }
}

