/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.servlets.filters.contentRewrite;

import com.google.common.hash.Hashing;
import java.util.TreeSet;
import javax.servlet.http.HttpSession;
import pt.ist.fenixWebFramework.servlets.filters.contentRewrite.RenderersSessionSecret;

public final class GenericChecksumRewriter {
    public static final String CHECKSUM_ATTRIBUTE_NAME = "_request_checksum_";
    public static final String NO_CHECKSUM_PREFIX = "<!-- NO_CHECKSUM -->";
    private static final int LENGTH_OF_NO_CHECKSUM_PREFIX = "<!-- NO_CHECKSUM -->".length();
    private static final String OPEN_A = "<a ";
    private static final String OPEN_FORM = "<form ";
    private static final String PREFIX_JAVASCRIPT = "javascript:";
    private static final String PREFIX_MAILTO = "mailto:";
    private static final String PREFIX_HTTP = "http://";
    private static final String PREFIX_HTTPS = "https://";
    private static final char CLOSE = '>';
    private static final char CARDINAL = '#';
    private static final char QUESTION_MARK = '?';
    private final String sessionSecret;

    public GenericChecksumRewriter(HttpSession session) {
        this.sessionSecret = RenderersSessionSecret.computeSecretFromSession(session);
    }

    private String calculateChecksum(String source, int start, int end) {
        return GenericChecksumRewriter.calculateChecksum(source.substring(start, end), this.sessionSecret);
    }

    private static boolean isRelevantPart(String part) {
        return part.length() > 0 && !part.startsWith(CHECKSUM_ATTRIBUTE_NAME) && !part.startsWith("page=") && !part.startsWith("org.apache.struts.action.LOCALE") && !part.startsWith("javax.servlet.request.") && !part.startsWith("ok");
    }

    private static String calculateChecksum(TreeSet<String> strings, String sessionSecret) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : strings) {
            stringBuilder.append(string);
        }
        if (sessionSecret != null) {
            stringBuilder.append(sessionSecret);
        }
        String checksum = new String(Hashing.sha1().hashBytes(stringBuilder.toString().getBytes()).toString());
        return checksum;
    }

    public static String calculateChecksum(String requestString, HttpSession session) {
        return GenericChecksumRewriter.calculateChecksum(requestString, RenderersSessionSecret.computeSecretFromSession(session));
    }

    private static String calculateChecksum(String requestString, String sessionSecret) {
        int indexLastCardinal = requestString.lastIndexOf(35);
        String string = indexLastCardinal >= 0 ? requestString.substring(0, indexLastCardinal) : requestString;
        String[] parts = string.split("\\?|&amp;|&");
        TreeSet<String> strings = new TreeSet<String>();
        for (String part : parts) {
            if (!GenericChecksumRewriter.isRelevantPart(part)) continue;
            int indexOfEquals = part.indexOf(61);
            if (indexOfEquals >= 0) {
                strings.add(part.substring(0, indexOfEquals));
                strings.add(part.substring(indexOfEquals + 1, part.length()));
                continue;
            }
            strings.add(part);
        }
        return GenericChecksumRewriter.calculateChecksum(strings, sessionSecret);
    }

    public static String injectChecksumInUrl(String contextPath, String url, HttpSession session) {
        String checksum = "_request_checksum_=" + GenericChecksumRewriter.calculateChecksum(contextPath + url, session);
        return url + "&" + checksum;
    }

    public String rewrite(String source) {
        int iOffset = 0;
        StringBuilder response = new StringBuilder();
        while (true) {
            int indexOfAopen = source.indexOf(OPEN_A, iOffset);
            int indexOfFormOpen = source.indexOf(OPEN_FORM, iOffset);
            if (indexOfAopen >= 0 && (indexOfFormOpen < 0 || indexOfAopen < indexOfFormOpen)) {
                if (!this.isPrefixed(source, indexOfAopen)) {
                    int indexOfAclose = source.indexOf(62, indexOfAopen);
                    if (indexOfAclose < 0) break;
                    int indexOfHrefBodyStart = this.findHrefBodyStart(source, indexOfAopen, indexOfAclose);
                    if (indexOfHrefBodyStart >= 0) {
                        char hrefBodyStartChar = source.charAt(indexOfHrefBodyStart - 1);
                        int indexOfHrefBodyEnd = this.findHrefBodyEnd(source, indexOfHrefBodyStart, hrefBodyStartChar);
                        if (indexOfHrefBodyEnd < 0) break;
                        int indexOfJavaScript = source.indexOf(PREFIX_JAVASCRIPT, indexOfHrefBodyStart);
                        int indexOfMailto = source.indexOf(PREFIX_MAILTO, indexOfHrefBodyStart);
                        int indexOfHttp = source.indexOf(PREFIX_HTTP, indexOfHrefBodyStart);
                        int indexOfHttps = source.indexOf(PREFIX_HTTPS, indexOfHrefBodyStart);
                        if (!(indexOfJavaScript >= 0 && indexOfJavaScript <= indexOfHrefBodyEnd || indexOfMailto >= 0 && indexOfMailto <= indexOfHrefBodyEnd || indexOfHttp >= 0 && indexOfHttp <= indexOfHrefBodyEnd || indexOfHttps >= 0 && indexOfHttps <= indexOfHrefBodyEnd)) {
                            boolean hasCardinal;
                            int indexOfCardinal = source.indexOf(35, indexOfHrefBodyStart);
                            if (indexOfCardinal == indexOfHrefBodyStart) {
                                iOffset = this.continueToNextToken(response, source, iOffset, indexOfAclose);
                                continue;
                            }
                            boolean bl = hasCardinal = indexOfCardinal > indexOfHrefBodyStart && indexOfCardinal < indexOfHrefBodyEnd;
                            if (hasCardinal) {
                                response.append(source, iOffset, indexOfCardinal);
                            } else {
                                response.append(source, iOffset, indexOfHrefBodyEnd);
                            }
                            String checksum = this.calculateChecksum(source, indexOfHrefBodyStart, indexOfHrefBodyEnd);
                            int indexOfQmark = source.indexOf(63, indexOfHrefBodyStart);
                            if (indexOfQmark == -1 || indexOfQmark > indexOfHrefBodyEnd) {
                                response.append('?');
                            } else {
                                response.append("&amp;");
                            }
                            response.append(CHECKSUM_ATTRIBUTE_NAME);
                            response.append("=");
                            response.append(checksum);
                            if (hasCardinal) {
                                response.append(source, indexOfCardinal, indexOfHrefBodyEnd);
                            }
                            int nextChar = indexOfAclose + 1;
                            response.append(source, indexOfHrefBodyEnd, nextChar);
                            iOffset = nextChar;
                            continue;
                        }
                        if (indexOfJavaScript < 0) {
                            indexOfJavaScript = Integer.MAX_VALUE;
                        }
                        if (indexOfMailto < 0) {
                            indexOfMailto = Integer.MAX_VALUE;
                        }
                        if (indexOfHttp < 0) {
                            indexOfHttp = Integer.MAX_VALUE;
                        }
                        if (indexOfHttps < 0) {
                            indexOfHttps = Integer.MAX_VALUE;
                        }
                        int nextIndex = Math.min(Math.min(indexOfJavaScript, indexOfMailto), Math.min(indexOfHttps, indexOfHttp));
                        response.append(source, iOffset, nextIndex);
                        iOffset = nextIndex;
                        continue;
                    }
                    iOffset = this.continueToNextToken(response, source, iOffset, indexOfAopen);
                    continue;
                }
                iOffset = this.continueToNextToken(response, source, iOffset, indexOfAopen);
                continue;
            }
            if (indexOfFormOpen < 0) break;
            if (!this.isPrefixed(source, indexOfFormOpen)) {
                int indexOfFormClose = source.indexOf(62, indexOfFormOpen);
                if (indexOfFormClose < 0) break;
                int indexOfFormActionBodyStart = this.findFormActionBodyStart(source, indexOfFormOpen, indexOfFormClose);
                if (indexOfFormActionBodyStart >= 0) {
                    int indexOfFormActionBodyEnd = this.findFormActionBodyEnd(source, indexOfFormActionBodyStart);
                    if (indexOfFormActionBodyEnd < 0) break;
                    int nextChar = indexOfFormClose + 1;
                    response.append(source, iOffset, nextChar);
                    String checksum = this.calculateChecksum(source, indexOfFormActionBodyStart, indexOfFormActionBodyEnd);
                    response.append("<input type=\"hidden\" name=\"");
                    response.append(CHECKSUM_ATTRIBUTE_NAME);
                    response.append("\" value=\"");
                    response.append(checksum);
                    response.append("\"/>");
                    iOffset = nextChar;
                    continue;
                }
                iOffset = this.continueToNextToken(response, source, iOffset, indexOfFormOpen);
                continue;
            }
            iOffset = this.continueToNextToken(response, source, iOffset, indexOfFormOpen);
        }
        response.append(source, iOffset, source.length());
        return response.toString();
    }

    private boolean isPrefixed(String source, int indexOfTagOpen) {
        return NO_CHECKSUM_PREFIX.regionMatches(0, source, indexOfTagOpen - LENGTH_OF_NO_CHECKSUM_PREFIX, LENGTH_OF_NO_CHECKSUM_PREFIX);
    }

    private int continueToNextToken(StringBuilder response, String source, int iOffset, int indexOfTag) {
        int nextOffset = indexOfTag + 1;
        response.append(source, iOffset, nextOffset);
        return nextOffset;
    }

    private int findFormActionBodyEnd(String source, int offset) {
        int i = offset;
        char c = source.charAt(i);
        while (c != '\"' && c != '\'' && c != ' ' && c != '>') {
            if (++i == source.length()) {
                return -1;
            }
            c = source.charAt(i);
        }
        return i;
    }

    private int findFormActionBodyStart(String source, int offset, int limit) {
        int indexOfHref = source.indexOf("action=", offset);
        if (indexOfHref < 0 || indexOfHref >= limit) {
            return -1;
        }
        int nextChar = indexOfHref + 7;
        return source.charAt(nextChar) == '\"' || source.charAt(nextChar) == '\'' ? nextChar + 1 : nextChar;
    }

    private int findHrefBodyEnd(String source, int offset, char hrefBodyStartChar) {
        int i = offset;
        if (hrefBodyStartChar == '=') {
            char c = source.charAt(i);
            while (c != ' ' && c != '>') {
                if (++i == source.length()) {
                    return -1;
                }
                c = source.charAt(i);
            }
        } else {
            char c = source.charAt(i);
            while (c != hrefBodyStartChar) {
                if (++i == source.length()) {
                    return -1;
                }
                c = source.charAt(i);
            }
        }
        return i;
    }

    private int findHrefBodyStart(String source, int offset, int limit) {
        int indexOfHref = source.indexOf("href=", offset);
        if (indexOfHref < 0 || indexOfHref >= limit) {
            return -1;
        }
        int nextChar = indexOfHref + 5;
        return source.charAt(nextChar) == '\"' || source.charAt(nextChar) == '\'' ? nextChar + 1 : nextChar;
    }
}

