/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.validators;

import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;

public class UrlValidator
extends HtmlValidator {
    private static final String[] validSchemes = new String[]{"http", "https"};
    private static final String DEFAULT_SCHEME = "http";
    private boolean required;

    public UrlValidator() {
        this.setKey(true);
        this.setMessage("renderers.validator.url");
        this.setRequired(true);
    }

    public UrlValidator(HtmlChainValidator htmlChainValidator) {
        super(htmlChainValidator);
        this.setKey(true);
        this.setMessage("renderers.validator.url");
        this.setRequired(true);
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public void performValidation() {
        if (this.hasValue()) {
            org.apache.commons.validator.routines.UrlValidator urlValidator = new org.apache.commons.validator.routines.UrlValidator(validSchemes);
            this.setValid(urlValidator.isValid(this.buildUrlForValidation()));
        } else {
            this.setValid(!this.isRequired());
        }
    }

    private boolean hasValue() {
        return this.getComponent().getValue() != null && this.getComponent().getValue().length() > 0;
    }

    private String buildUrlForValidation() {
        String url = this.getComponent().getValue();
        for (String scheme : validSchemes) {
            if (!url.startsWith(scheme)) continue;
            return url;
        }
        return "http://" + url;
    }
}

