/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.validators;

import pt.ist.fenixWebFramework.renderers.components.HtmlCheckBoxList;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;

public class RequiredNrItemsValidator
extends HtmlValidator {
    private Integer nrRequiredItems;

    public RequiredNrItemsValidator() {
    }

    public RequiredNrItemsValidator(HtmlChainValidator htmlChainValidator) {
        super(htmlChainValidator);
    }

    @Override
    public void performValidation() {
        HtmlCheckBoxList component = (HtmlCheckBoxList)this.getComponent();
        String[] values = component.getValues();
        this.defineMessage();
        this.setValid(values.length >= this.getNrRequiredItems());
    }

    private void defineMessage() {
        this.setKey(false);
        if (this.getNrRequiredItems() == null) {
            throw new RuntimeException("renderers.validator.nr.items.not.specified");
        }
        this.setMessage(RenderUtils.getFormatedResourceString(this.getBundle(), "renderers.validator.invalid.nrItems", this.getNrRequiredItems()));
    }

    public void setNrRequiredItems(Integer nrRequiredItems) {
        this.nrRequiredItems = nrRequiredItems;
    }

    public Integer getNrRequiredItems() {
        return this.nrRequiredItems;
    }
}

