/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.validators;

import com.google.common.base.Strings;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;

public class DoubleValidator
extends HtmlValidator {
    public DoubleValidator() {
    }

    public DoubleValidator(HtmlChainValidator htmlChainValidator) {
        super(htmlChainValidator);
    }

    @Override
    public String getErrorMessage() {
        return RenderUtils.getResourceString("renderers.validator.number");
    }

    @Override
    public void performValidation() {
        String numberText = this.getComponent().getValue().trim();
        if (!Strings.isNullOrEmpty((String)numberText)) {
            try {
                Double.parseDouble(numberText);
                this.setValid(true);
            }
            catch (NumberFormatException e) {
                this.setValid(false);
            }
        }
    }
}

