/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import org.apache.commons.beanutils.PropertyUtils;

public class RendererPropertyUtils {
    private static Class<?> getPropertyDescriptor(Class type, String name) {
        PropertyDescriptor[] descriptors;
        for (PropertyDescriptor descriptor : descriptors = PropertyUtils.getPropertyDescriptors((Class)type)) {
            String simpleName;
            if (descriptor.getName().equals(name)) {
                return descriptor.getPropertyType();
            }
            if (name.contains("(")) {
                simpleName = name.substring(0, name.indexOf(40));
                if (descriptor.getName().equals(simpleName)) {
                    ParameterizedType returnType = (ParameterizedType)descriptor.getReadMethod().getGenericReturnType();
                    return (Class)returnType.getActualTypeArguments()[1];
                }
            }
            if (!name.contains("[")) continue;
            simpleName = name.substring(0, name.indexOf(91));
            if (!descriptor.getName().equals(simpleName)) continue;
            ParameterizedType returnType = (ParameterizedType)descriptor.getReadMethod().getGenericReturnType();
            return (Class)returnType.getActualTypeArguments()[0];
        }
        return null;
    }

    public static Class getPropertyType(Class type, String name) {
        String remaining;
        String firstPart;
        int index = name.indexOf(".");
        if (index == -1) {
            firstPart = name;
            remaining = null;
        } else {
            firstPart = name.substring(0, index);
            remaining = name.substring(index + 1);
        }
        Class clazz = RendererPropertyUtils.getPropertyDescriptor(type, firstPart);
        if (clazz == null) {
            throw new RuntimeException("cound not find property '" + firstPart + "' in type " + type);
        }
        Class result = remaining == null ? clazz : RendererPropertyUtils.getPropertyType(clazz, remaining);
        return result;
    }

    private static Object getCreatedProperty(Object object, String name, boolean create) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        Object property = RendererPropertyUtils.getProperty(object, name, create);
        if (property == null && create) {
            Class type = RendererPropertyUtils.getPropertyType(object.getClass(), name);
            property = type.newInstance();
            PropertyUtils.setProperty((Object)object, (String)name, (Object)property);
        }
        return property;
    }

    public static Object getProperty(Object object, String name, boolean create) {
        String message = "could not get property '" + name + "' for object '" + object + "'";
        try {
            int index = name.indexOf(".");
            if (index == -1) {
                return PropertyUtils.getProperty((Object)object, (String)name);
            }
            String firstPart = name.substring(0, index);
            String remaining = name.substring(index + 1);
            Object target = RendererPropertyUtils.getCreatedProperty(object, firstPart, create);
            if (target == null) {
                return null;
            }
            return RendererPropertyUtils.getProperty(target, remaining, create);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(message, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(message, e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(message, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(message, e);
        }
    }

    public static void setProperty(Object object, String name, Object value, boolean create) {
        String message = "could not set property '" + name + "' for object '" + object + "' with value '" + value + "'";
        try {
            int index = name.lastIndexOf(".");
            if (index == -1) {
                PropertyUtils.setProperty((Object)object, (String)name, (Object)value);
                return;
            }
            String firstPart = name.substring(0, index);
            String remaining = name.substring(index + 1);
            Object target = RendererPropertyUtils.getCreatedProperty(object, firstPart, create);
            if (target != null) {
                PropertyUtils.setProperty((Object)target, (String)remaining, (Object)value);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(message, e);
        }
        catch (InvocationTargetException e) {
            if (!(e.getCause() instanceof RuntimeException)) {
                throw new RuntimeException(message, e.getTargetException());
            }
            throw (RuntimeException)e.getTargetException();
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(message, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(message, e);
        }
    }
}

