/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import pt.ist.fenixWebFramework.renderers.Renderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.contexts.PresentationContext;
import pt.ist.fenixWebFramework.renderers.exceptions.NoRendererException;
import pt.ist.fenixWebFramework.renderers.exceptions.NoSuchSchemaException;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;
import pt.ist.fenixWebFramework.renderers.utils.RenderMode;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.utils.RendererDescription;
import pt.ist.fenixWebFramework.renderers.utils.RendererRegistry;

public class RenderKit {
    private static RenderKit instance = new RenderKit();
    private final RendererRegistry inputRenderers = new RendererRegistry();
    private final RendererRegistry outputRenderers = new RendererRegistry();
    private final Map<String, Schema> schemaRegistry = new HashMap<String, Schema>();

    private RenderKit() {
    }

    public static void reset() {
        instance = new RenderKit();
    }

    public static RenderKit getInstance() {
        return instance;
    }

    private final RendererRegistry registry(RenderMode mode) {
        switch (mode) {
            case INPUT: {
                return this.inputRenderers;
            }
            case OUTPUT: {
                return this.outputRenderers;
            }
        }
        throw new IllegalArgumentException("Could not find registry for mode: " + (Object)((Object)mode));
    }

    public void registerRenderer(RenderMode mode, Class<?> type, String layout, Class<? extends Renderer> renderer, Properties defaultProperties) {
        this.registry(mode).registerRenderer(type, layout, renderer, defaultProperties);
    }

    public void registerSchema(Schema schema) {
        this.schemaRegistry.put(schema.getName(), schema);
    }

    public Schema findSchema(String schemaName) {
        if (schemaName == null) {
            return null;
        }
        if (!this.schemaRegistry.containsKey(schemaName)) {
            throw new NoSuchSchemaException(schemaName);
        }
        return this.schemaRegistry.get(schemaName);
    }

    public boolean hasSchema(String schemaName) {
        return this.schemaRegistry.containsKey(schemaName);
    }

    public RendererDescription getExactRendererDescription(RenderMode mode, Class type, String layout) {
        return this.registry(mode).getExactRenderDescription(type, layout);
    }

    public RendererDescription getRendererDescription(RenderMode mode, Class type, String layout) {
        return this.registry(mode).getRenderDescription(type, layout);
    }

    private RendererDescription getSpecificRendererDescription(RenderMode mode, Class type, String layout) {
        try {
            return this.getRendererDescription(mode, type, layout);
        }
        catch (NoRendererException e) {
            return this.getRendererDescription(mode, type, null);
        }
    }

    public Renderer getRenderer(RenderMode mode, Class type, String layout) {
        RendererDescription rendererDescription = this.getSpecificRendererDescription(mode, type, layout);
        return rendererDescription.createRenderer();
    }

    public Renderer getRenderer(PresentationContext context, Class type, String layout) {
        return this.getRenderer(context.getRenderMode(), type, layout);
    }

    private void prepareRenderer(Renderer renderer, PresentationContext context) {
        renderer.setContext(context);
        Properties properties = context.getProperties();
        if (properties != null) {
            RenderUtils.setProperties(renderer, properties);
        }
    }

    public HtmlComponent render(PresentationContext context, Object object) {
        return this.render(context, object, object.getClass());
    }

    public HtmlComponent render(PresentationContext context, Object object, Class type) {
        Renderer renderer = this.getRenderer(context, type, context.getLayout());
        return this.renderUsing(renderer, context, object, type);
    }

    public HtmlComponent renderUsing(Renderer renderer, PresentationContext context, Object object, Class type) {
        this.prepareRenderer(renderer, context);
        return renderer.render(object, type);
    }
}

