/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.taglib;

import java.io.IOException;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.components.state.Message;
import pt.ist.fenixWebFramework.renderers.components.state.SlotMessage;
import pt.ist.fenixWebFramework.renderers.taglib.HasMessagesTag;
import pt.ist.fenixWebFramework.renderers.taglib.MessagesTag;

public class MessageTag
extends TagSupport {
    private static final Logger logger = LoggerFactory.getLogger(MessageTag.class);
    private String forName;
    private String type;
    private String showWhat;

    public String getFor() {
        return this.forName;
    }

    public void setFor(String forName) {
        this.forName = forName;
    }

    public String getShow() {
        return this.showWhat;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setShow(String show) {
        this.showWhat = show;
    }

    public void release() {
        super.release();
        this.forName = null;
        this.showWhat = null;
    }

    public int doStartTag() throws JspException {
        Message message = this.getMessage();
        if (message != null) {
            this.writeMessage(message);
        }
        return 0;
    }

    private Message getMessage() {
        MessagesTag parent = (MessagesTag)MessageTag.findAncestorWithClass((Tag)this, MessagesTag.class);
        if (this.getFor() == null || parent != null) {
            return parent.getCurrentMessage();
        }
        IViewState viewState = HasMessagesTag.getViewStateWithId(this.pageContext, this.getFor());
        if (viewState == null) {
            return null;
        }
        List<Message> messages = viewState.getMessages();
        if (!messages.isEmpty()) {
            return messages.get(0);
        }
        return null;
    }

    private void writeMessage(Message message) throws JspException {
        Message.Type type = this.getMessageType();
        if (type == null || type.equals((Object)message.getType())) {
            try {
                if ("slot".equalsIgnoreCase(this.getShow()) || "label".equalsIgnoreCase(this.getShow())) {
                    if (message instanceof SlotMessage) {
                        SlotMessage slotMessage = (SlotMessage)message;
                        if (slotMessage.getSlot() != null) {
                            this.pageContext.getOut().write(slotMessage.getSlot().getLabel());
                        } else {
                            logger.warn("asked to show " + this.getShow() + " but not " + this.getShow() + " was defined");
                        }
                    }
                } else {
                    this.pageContext.getOut().write(message.getMessage());
                }
            }
            catch (IOException e) {
                throw new JspException((Throwable)e);
            }
        }
    }

    private Message.Type getMessageType() {
        MessagesTag parent = (MessagesTag)MessageTag.findAncestorWithClass((Tag)this, MessagesTag.class);
        if (this.getType() != null) {
            if (parent != null && parent.getMessageType() != null) {
                logger.warn("parent 'messages' tag is beeing ignored since the 'type' attribute was specified");
            }
            return Message.Type.valueOf(String.valueOf(this.getType()).toUpperCase());
        }
        if (parent != null) {
            return parent.getMessageType();
        }
        return null;
    }

    public int doEndTag() throws JspException {
        return 6;
    }
}

