/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.taglib;

import java.util.Arrays;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixWebFramework.renderers.taglib.PropertyContainerTag;

public class LinkFormatTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(LinkFormatTag.class);
    private static final String ELEMENTS_SEPARATOR = ",";
    private String name;
    private String link;
    private String label;
    private String condition;
    private String confirmation;
    private String order;
    private String target;
    private String module;
    private String contextRelative;
    private String hasContext;
    private static List<String> ACCEPTED_TARGETS = Arrays.asList("_blank,_self,_parent,_top".split(","));

    public void release() {
        super.release();
        this.name = null;
        this.link = null;
        this.label = null;
        this.condition = null;
        this.order = null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getConfirmation() {
        return this.confirmation;
    }

    public void setConfirmation(String confirmation) {
        this.confirmation = confirmation;
    }

    public boolean hasConfirmation() {
        return !this.empty(this.confirmation);
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    private boolean hasTarget() {
        return !this.empty(this.target);
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    private boolean hasModule() {
        return this.module != null;
    }

    public String getContextRelative() {
        return this.contextRelative;
    }

    public void setContextRelative(String contextRelative) {
        this.contextRelative = contextRelative;
    }

    public boolean hasContextRelative() {
        return this.contextRelative != null;
    }

    public String getHasContext() {
        return this.hasContext;
    }

    public void setHasContext(String hasContext) {
        this.hasContext = hasContext;
    }

    public boolean hasContext() {
        return this.hasContext != null;
    }

    public int doEndTag() throws JspException {
        PropertyContainerTag parent = (PropertyContainerTag)LinkFormatTag.findAncestorWithClass((Tag)this, PropertyContainerTag.class);
        if (parent != null) {
            this.setProperties(parent);
        } else {
            logger.warn("LinkFormatTag tag was used inside an invalid container (It requires a PropertyContainer)");
        }
        return super.doEndTag();
    }

    private void setProperties(PropertyContainerTag parent) throws JspException {
        this.setLink(parent).setLabel(parent).setCondition(parent).setConfirmation(parent).setOrder(parent).setTarget(parent).setModule(parent).setContextRelative(parent).setHasContext(parent);
    }

    private LinkFormatTag setLink(PropertyContainerTag parent) {
        parent.addProperty(String.format("%s(%s)", this.getLinkType(), this.getName()), this.getLink());
        return this;
    }

    private LinkFormatTag setConfirmation(PropertyContainerTag parent) throws JspException {
        String bundle;
        if (!this.hasConfirmation()) {
            return this;
        }
        String[] values = this.getConfirmation().split(ELEMENTS_SEPARATOR);
        if (values.length == 0) {
            return this;
        }
        String key = values[0].trim();
        if (this.empty(key)) {
            throw new JspException("confirmation is specified but no value found");
        }
        this.setConfirmationKey(parent, key);
        if (values.length > 1 && !this.empty(bundle = values[1].trim())) {
            this.setConfirmationBundle(parent, bundle);
        }
        return this;
    }

    private void setConfirmationKey(PropertyContainerTag parent, String key) {
        parent.addProperty(String.format("confirmationKey(%s)", this.getName()), key);
    }

    private void setConfirmationBundle(PropertyContainerTag parent, String bundle) {
        parent.addProperty(String.format("confirmationBundle(%s)", this.getName()), bundle);
    }

    private LinkFormatTag setLabel(PropertyContainerTag parent) throws JspException {
        String bundle;
        String[] values = this.getLabel().split(ELEMENTS_SEPARATOR);
        if (values.length < 1) {
            throw new JspException("must define label value");
        }
        String key = values[0].trim();
        if (this.empty(key)) {
            throw new JspException("must define label value");
        }
        this.setKey(parent, key);
        if (values.length > 1 && !this.empty(bundle = values[1].trim())) {
            this.setBundle(parent, bundle);
        }
        return this;
    }

    private void setKey(PropertyContainerTag parent, String key) {
        parent.addProperty(String.format("key(%s)", this.getName()), key);
    }

    private void setBundle(PropertyContainerTag parent, String bundle) {
        parent.addProperty(String.format("bundle(%s)", this.getName()), bundle);
    }

    private LinkFormatTag setCondition(PropertyContainerTag parent) {
        if (!this.empty(this.getCondition())) {
            parent.addProperty(String.format("%s(%s)", this.getConditionName(), this.getName()), this.getConditionValue());
        }
        return this;
    }

    private LinkFormatTag setOrder(PropertyContainerTag parent) {
        if (!this.empty(this.getOrder())) {
            parent.addProperty(String.format("order(%s)", this.getName()), this.getOrder());
        }
        return this;
    }

    private String getLinkType() {
        return this.getLink().matches(".*\\$\\{.*\\}.*") ? "linkFormat" : "link";
    }

    private String getConditionName() {
        return this.getCondition().startsWith("!") ? "visibleIfNot" : "visibleIf";
    }

    private String getConditionValue() {
        return this.getCondition().replace("!", "");
    }

    private boolean empty(String value) {
        return value == null || value.length() == 0;
    }

    private LinkFormatTag setTarget(PropertyContainerTag parent) throws JspException {
        if (this.hasTarget()) {
            String target = this.getFormattedTarget();
            if (this.targetIsValid(target)) {
                throw new JspException("invalid target value. Accepted values: _blank, _self, _parent, _top");
            }
            parent.addProperty(String.format("target(%s)", this.getName()), target);
        }
        return this;
    }

    private LinkFormatTag setModule(PropertyContainerTag parent) throws JspException {
        if (this.hasModule()) {
            parent.addProperty(String.format("module(%s)", this.getName()), this.module);
        }
        return this;
    }

    private LinkFormatTag setContextRelative(PropertyContainerTag parent) throws JspException {
        if (this.hasContextRelative()) {
            parent.addProperty(String.format("contextRelative(%s)", this.getName()), this.contextRelative);
        }
        return this;
    }

    private LinkFormatTag setHasContext(PropertyContainerTag parent) throws JspException {
        if (this.hasContext()) {
            parent.addProperty(String.format("hasContext(%s)", this.getName()), this.hasContext);
        }
        return this;
    }

    private String getFormattedTarget() {
        String target = this.getTarget();
        return target.startsWith("_") ? target : "_" + target;
    }

    private boolean targetIsValid(String value) {
        return !ACCEPTED_TARGETS.contains(value);
    }
}

