/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.taglib;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import pt.ist.fenixWebFramework.renderers.taglib.ContextTag;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class FormTag
extends ContextTag {
    private String action;
    private String target;
    private String encoding;
    private boolean confirmationNeeded;
    private String bundle;
    private String titleKey;
    private String messageKey;
    private String okKey;
    private String cancelKey;
    private String formId;
    private String style;

    public boolean isConfirmationNeeded() {
        return this.confirmationNeeded;
    }

    public void setConfirmationNeeded(boolean confirmationNeeded) {
        this.confirmationNeeded = confirmationNeeded;
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getTitleKey() {
        return this.titleKey;
    }

    public void setTitleKey(String titleKey) {
        this.titleKey = titleKey;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public String getOkKey() {
        return this.okKey;
    }

    public void setOkKey(String okKey) {
        this.okKey = okKey;
    }

    public String getCancelKey() {
        return this.cancelKey;
    }

    public void setCancelKey(String cancelKey) {
        this.cancelKey = cancelKey;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    @Override
    public int doStartTag() throws JspException {
        this.writeStartForm();
        return super.doStartTag();
    }

    @Override
    public int doEndTag() throws JspException {
        super.doEndTag();
        this.writeEndForm();
        return 6;
    }

    private void writeStartForm() throws JspException {
        String path;
        StringBuilder formHead = new StringBuilder();
        if (this.isConfirmationNeeded()) {
            path = ((HttpServletRequest)this.pageContext.getRequest()).getContextPath();
            formHead.append("<script type=\"text/javascript\" src=\"");
            formHead.append(path);
            formHead.append("/bennu-renderers/js/jquery.ui.draggable.js\"></script>\n");
            formHead.append("<script type=\"text/javascript\" src=\"");
            formHead.append(path);
            formHead.append("/bennu-renderers/js/jquery.alerts.js\"></script>\n");
            formHead.append("<script type=\"text/javascript\" src=\"");
            formHead.append(path);
            formHead.append("/bennu-renderers/js/alertHandlers.js\"></script>\n");
        }
        formHead.append("<form ");
        if (this.getId() != null) {
            this.formId = this.getId();
            formHead.append("id=\"" + this.getId() + "\" ");
        }
        if (this.getAction() != null) {
            path = RenderUtils.getModuleRelativePath(this.getAction());
            formHead.append("action=\"" + path + "\" ");
        }
        if (this.getEncoding() != null) {
            formHead.append("enctype=\"" + this.getEncoding() + "\" ");
        }
        if (this.getTarget() != null) {
            formHead.append("target=\"" + this.getTarget() + "\" ");
        }
        if (this.getStyle() != null) {
            formHead.append("style=\"" + this.getStyle() + "\" ");
        }
        formHead.append("method=\"post\" class='form-horizontal'>\n");
        try {
            this.pageContext.getOut().write(formHead.toString());
        }
        catch (IOException e) {
            throw new JspException("could not generate form");
        }
    }

    private void writeEndForm() throws JspException {
        StringBuilder formTail = new StringBuilder();
        if (this.isConfirmationNeeded()) {
            formTail.append("<input class=\"inputbutton\" type=\"button\" value=\"");
            formTail.append(RenderUtils.getResourceString("RENDERER_RESOURCES", "renderers.form.submit.name"));
            formTail.append("\" onClick=\"requestConfirmation('");
            formTail.append(this.formId);
            formTail.append("','");
            formTail.append(RenderUtils.getResourceString(this.getBundle(), this.getTitleKey()));
            formTail.append("','");
            formTail.append(RenderUtils.getResourceString(this.getBundle(), this.getMessageKey()));
            formTail.append("');\"/>");
        }
        formTail.append("</form>");
        try {
            this.pageContext.getOut().write(formTail.toString());
        }
        catch (IOException e) {
            throw new JspException("could not generate form");
        }
    }
}

