/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.taglib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import pt.ist.fenixWebFramework.renderers.components.HtmlHiddenField;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.components.state.LifeCycleConstants;
import pt.ist.fenixWebFramework.renderers.components.state.ViewState;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;

public class ContextTag
extends TagSupport {
    private List<IViewState> viewStates = new ArrayList<IViewState>();
    private MetaObject metaObject;

    public void release() {
        super.release();
        this.viewStates = new ArrayList<IViewState>();
        this.metaObject = null;
    }

    public int doStartTag() throws JspException {
        return 1;
    }

    public int doEndTag() throws JspException {
        try {
            if (!this.viewStates.isEmpty()) {
                HtmlHiddenField hidden = new HtmlHiddenField(LifeCycleConstants.VIEWSTATE_PARAM_NAME, this.encodeViewStates());
                hidden.draw(this.pageContext);
            }
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        this.release();
        return 6;
    }

    private String encodeViewStates() throws IOException {
        return ViewState.encodeToBase64(this.viewStates);
    }

    public void addViewState(IViewState viewState) {
        this.viewStates.add(viewState);
    }

    public void setMetaObject(MetaObject metaObject) {
        this.metaObject = metaObject;
    }

    public MetaObject getMetaObject() {
        return this.metaObject;
    }
}

