/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import pt.ist.fenixWebFramework.rendererExtensions.factories.CreationDomainMetaObject;
import pt.ist.fenixWebFramework.rendererExtensions.factories.DomainMetaObject;
import pt.ist.fenixWebFramework.renderers.model.CompositeSlotSetter;
import pt.ist.fenixWebFramework.renderers.model.CreationMetaObject;
import pt.ist.fenixWebFramework.renderers.model.InstanceCreator;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectCollection;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixWebFramework.renderers.model.MetaSlotWithDefault;
import pt.ist.fenixWebFramework.renderers.model.PrimitiveMetaObject;
import pt.ist.fenixWebFramework.renderers.model.SchemaFactory;
import pt.ist.fenixWebFramework.renderers.model.SimpleMetaObject;
import pt.ist.fenixWebFramework.renderers.model.TransientMetaObject;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;
import pt.ist.fenixWebFramework.renderers.schemas.SchemaSlotDescription;
import pt.ist.fenixWebFramework.renderers.schemas.Signature;
import pt.ist.fenixWebFramework.renderers.schemas.SignatureParameter;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;
import pt.ist.fenixframework.DomainObject;

public final class MetaObjectFactory {
    private static final Class<?>[] primitiveTypes = new Class[]{String.class, Number.class, Integer.TYPE, Long.TYPE, Short.TYPE, Character.TYPE, Float.TYPE, Double.TYPE, Date.class, Enum.class};

    public static MetaObject createObject(Object object, Schema schema) {
        Collection collection;
        Schema usedSchema = schema;
        if (usedSchema == null && !(object instanceof Collection)) {
            usedSchema = SchemaFactory.create(object);
        }
        if (usedSchema == null && object instanceof Collection && !(collection = (Collection)object).isEmpty()) {
            usedSchema = SchemaFactory.create(collection.iterator().next());
        }
        return MetaObjectFactory.createMetaObject(object, usedSchema);
    }

    public static MetaObject createObject(Class type, Schema schema) {
        Schema usedSchema = schema;
        if (usedSchema == null) {
            usedSchema = SchemaFactory.create(type);
        }
        return MetaObjectFactory.createMetaObject(type, usedSchema);
    }

    public static MetaSlot createSlot(MetaObject metaObject, SchemaSlotDescription slotDescription) {
        return MetaObjectFactory.createMetaSlot(metaObject, slotDescription);
    }

    private static MetaObject createMetaObject(Object object, Schema schema) {
        if (object instanceof Collection) {
            MetaObjectCollection multipleMetaObject = new MetaObjectCollection();
            for (Object element : (Collection)object) {
                multipleMetaObject.add(MetaObjectFactory.createOneMetaObject(element, schema));
            }
            return multipleMetaObject;
        }
        return MetaObjectFactory.createOneMetaObject(object, schema);
    }

    private static MetaObject createMetaObject(Class type, Schema schema) {
        CreationMetaObject metaObject;
        if (DomainObject.class.isAssignableFrom(type)) {
            return MetaObjectFactory.createCreationMetaObject(type, schema);
        }
        try {
            metaObject = new CreationMetaObject(type);
        }
        catch (Exception e) {
            throw new RuntimeException("could not create a new instance of " + type, e);
        }
        metaObject.setSchema(schema);
        MetaObjectFactory.addSlotDescriptions(schema, metaObject);
        MetaObjectFactory.setInstanceCreator(type, schema, metaObject);
        MetaObjectFactory.addCompositeSlotSetters(schema, metaObject);
        return metaObject;
    }

    private static MetaObject createCreationMetaObject(Class type, Schema schema) {
        CreationDomainMetaObject metaObject = new CreationDomainMetaObject(type);
        metaObject.setSchema(schema);
        MetaObjectFactory.addSlotDescriptions(schema, metaObject);
        MetaObjectFactory.setInstanceCreator(schema.getType(), schema, metaObject);
        MetaObjectFactory.addCompositeSlotSetters(schema, metaObject);
        return metaObject;
    }

    private static void setInstanceCreator(Class type, Schema schema, MetaObject metaObject) {
        Signature signature = schema.getConstructor();
        if (signature != null) {
            InstanceCreator creator = new InstanceCreator(type);
            for (SignatureParameter parameter : signature.getParameters()) {
                SchemaSlotDescription description = parameter.getSlotDescription();
                for (MetaSlot slot : metaObject.getAllSlots()) {
                    if (!slot.getName().equals(description.getSlotName())) continue;
                    creator.addArgument(slot, parameter.getType());
                }
            }
            metaObject.setInstanceCreator(creator);
        }
    }

    private static void addSlotDescriptions(Schema schema, MetaObject metaObject) {
        List<SchemaSlotDescription> slotDescriptions = schema.getSlotDescriptions();
        for (SchemaSlotDescription description : slotDescriptions) {
            MetaSlot metaSlot = MetaObjectFactory.createMetaSlot(metaObject, description);
            if (!description.isHidden()) {
                metaObject.addSlot(metaSlot);
                continue;
            }
            metaObject.addHiddenSlot(metaSlot);
        }
    }

    private static void addCompositeSlotSetters(Schema schema, SimpleMetaObject metaObject) {
        for (Signature setterSignature : schema.getSpecialSetters()) {
            CompositeSlotSetter compositeSlotSetter = new CompositeSlotSetter(metaObject, setterSignature.getName());
            for (SignatureParameter parameter : setterSignature.getParameters()) {
                SchemaSlotDescription description = parameter.getSlotDescription();
                for (MetaSlot slot : metaObject.getAllSlots()) {
                    if (!slot.getName().equals(description.getSlotName())) continue;
                    compositeSlotSetter.addArgument(slot, parameter.getType());
                }
            }
            metaObject.addCompositeSetter(compositeSlotSetter);
        }
    }

    private static MetaObject createOneMetaObject(Object object, Schema schema) {
        MetaObject result;
        if (object instanceof DomainObject) {
            return MetaObjectFactory.createDomainMetaObject(object, schema);
        }
        if (MetaObjectFactory.isPrimitiveObject(object)) {
            result = new PrimitiveMetaObject(object);
        } else if (object != null && !(object instanceof Serializable)) {
            TransientMetaObject metaObject = new TransientMetaObject(object);
            MetaObjectFactory.addSlotDescriptions(schema, metaObject);
            result = metaObject;
        } else {
            SimpleMetaObject metaObject = new SimpleMetaObject(object);
            MetaObjectFactory.addSlotDescriptions(schema, metaObject);
            MetaObjectFactory.addCompositeSlotSetters(schema, metaObject);
            result = metaObject;
        }
        result.setSchema(schema);
        return result;
    }

    private static MetaObject createDomainMetaObject(Object object, Schema schema) {
        DomainMetaObject metaObject = new DomainMetaObject((DomainObject)object);
        metaObject.setSchema(schema);
        MetaObjectFactory.addSlotDescriptions(schema, metaObject);
        MetaObjectFactory.addCompositeSlotSetters(schema, metaObject);
        return metaObject;
    }

    private static boolean isPrimitiveObject(Object object) {
        if (object == null) {
            return true;
        }
        for (Class<?> type : primitiveTypes) {
            if (!type.isAssignableFrom(object.getClass())) continue;
            return true;
        }
        return false;
    }

    private static MetaSlot createMetaSlot(MetaObject metaObject, SchemaSlotDescription slotDescription) {
        MetaSlot metaSlot = metaObject instanceof CreationMetaObject || metaObject instanceof CreationDomainMetaObject ? new MetaSlotWithDefault(metaObject, slotDescription.getSlotName()) : (metaObject instanceof DomainMetaObject ? new MetaSlot(metaObject, slotDescription.getSlotName()) : new MetaSlot(metaObject, slotDescription.getSlotName()));
        metaSlot.setLabelKey(slotDescription.getKey());
        metaSlot.setLabelArg0(slotDescription.getArg0());
        metaSlot.setBundle(slotDescription.getBundle());
        metaSlot.setSchema(RenderKit.getInstance().findSchema(slotDescription.getSchema()));
        metaSlot.setLayout(slotDescription.getLayout());
        metaSlot.setValidators(slotDescription.getValidators());
        metaSlot.setDefaultValue(slotDescription.getDefaultValue());
        metaSlot.setProperties(slotDescription.getProperties());
        metaSlot.setConverter(slotDescription.getConverter());
        metaSlot.setReadOnly(slotDescription.isReadOnly());
        metaSlot.setHelpLabel(slotDescription.getHelpLabel());
        metaSlot.setDescription(slotDescription.getDescription());
        metaSlot.setDescriptionFormat(slotDescription.getDescriptionFormat());
        return metaSlot;
    }
}

