/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.model;

import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixWebFramework.renderers.utils.ClassHierarchyTable;
import pt.ist.fenixframework.DomainObject;

public class DefaultValues {
    private static final Logger logger = LoggerFactory.getLogger(DefaultValues.class);
    protected static DefaultValues instance;
    private static ClassHierarchyTable<ValueCreator> defaultValues;

    protected DefaultValues() {
        Method[] methods;
        for (final Method m : methods = this.getClass().getMethods()) {
            Class<?>[] parameters;
            if (!m.getName().startsWith("createValue") || (parameters = m.getParameterTypes()).length != 3 || !parameters[1].equals(Class.class) || !parameters[2].equals(String.class)) continue;
            Class<?> type = parameters[0];
            try {
                this.registerCreator(type, new ValueCreator(){

                    @Override
                    public Object createValue(Class type, String defaultValue) {
                        try {
                            return m.invoke((Object)DefaultValues.this, null, type, defaultValue);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return null;
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void registerCreator(Class type, ValueCreator creator) {
        defaultValues.put(type, creator);
    }

    public Object createValue(Class type) {
        return defaultValues.get(type).createValue(type, null);
    }

    public Object createValue(Class type, String defaultValue) {
        return defaultValues.get(type).createValue(type, defaultValue);
    }

    public static DefaultValues getInstance() {
        if (instance == null) {
            instance = new DefaultValues();
        }
        return instance;
    }

    private boolean isEmptyString(String value) {
        return value == null || value.length() == 0;
    }

    public Object createValue(Object o, Class type, String defaultValue) throws InstantiationException, IllegalAccessException {
        return null;
    }

    public String createValue(String s, Class type, String defaultValue) {
        return defaultValue != null ? defaultValue : "";
    }

    public Number createValue(Number n, Class type, String defaultValue) {
        if (this.isEmptyString(defaultValue)) {
            return null;
        }
        try {
            return new Integer(defaultValue != null ? defaultValue : "0");
        }
        catch (NumberFormatException e) {
            try {
                return new Float(defaultValue != null ? defaultValue : "0.0");
            }
            catch (NumberFormatException e1) {
                logger.warn("could not create number from default value '" + defaultValue + "'", (Throwable)e1);
                return new Integer(0);
            }
        }
    }

    public Integer createValue(Integer i, Class type, String defaultValue) {
        if (this.isEmptyString(defaultValue)) {
            return null;
        }
        try {
            return new Integer(defaultValue != null ? defaultValue : "0");
        }
        catch (NumberFormatException e) {
            logger.warn("could not create integer from default value '" + defaultValue + "'", (Throwable)e);
            return new Integer(0);
        }
    }

    public Float createValue(Float n, Class type, String defaultValue) {
        if (this.isEmptyString(defaultValue)) {
            return null;
        }
        try {
            return new Float(defaultValue != null ? defaultValue : "0.0");
        }
        catch (NumberFormatException e) {
            logger.warn("could not create float from default value '" + defaultValue + "'", (Throwable)e);
            return new Float(0.0f);
        }
    }

    public Boolean createValue(Boolean b, Class type, String defaultValue) {
        if (this.isEmptyString(defaultValue)) {
            return null;
        }
        return new Boolean(defaultValue != null ? defaultValue : "false");
    }

    public Date createValue(Date d, Class type, String defaultValue) {
        if (this.isEmptyString(defaultValue)) {
            return null;
        }
        if (defaultValue != null) {
            try {
                return new SimpleDateFormat("dd/MM/yyyy").parse(defaultValue);
            }
            catch (ParseException e) {
                logger.warn("could not create date from default value '" + defaultValue + "'", (Throwable)e);
            }
        }
        return new Date();
    }

    public Enum createValue(Enum e, Class type, String defaultValue) {
        if (this.isEmptyString(defaultValue)) {
            return null;
        }
        T[] constants = type.getEnumConstants();
        if (defaultValue != null) {
            for (Object constant : constants) {
                if (!constant.toString().equals(defaultValue)) continue;
                return (Enum)constant;
            }
        }
        return null;
    }

    public DomainObject createValue(DomainObject o, Class type, String defaultValue) {
        return null;
    }

    static {
        defaultValues = new ClassHierarchyTable();
    }

    public static abstract class ValueCreator {
        public abstract Object createValue(Class var1, String var2);
    }
}

