/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.model;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixframework.core.WriteOnReadError;

public class CompositeSlotSetter
implements Serializable {
    private MetaObject metaObject;
    private final String setterName;
    private final List<MetaSlot> slots;
    private final List<Class> types;

    public CompositeSlotSetter(MetaObject metaObject, String setterName) {
        this.metaObject = metaObject;
        this.setterName = setterName;
        this.slots = new ArrayList<MetaSlot>();
        this.types = new ArrayList<Class>();
    }

    public MetaObject getMetaObject() {
        return this.metaObject;
    }

    public String getSetterName() {
        return this.setterName;
    }

    public void setMetaObject(MetaObject metaObject) {
        this.metaObject = metaObject;
    }

    public void addArgument(MetaSlot slot, Class type) {
        this.slots.add(slot);
        this.types.add(type);
        slot.setSetterIgnored(true);
    }

    public void executeSetter() {
        Object object = this.metaObject.getObject();
        try {
            Method method = this.getSetter(object.getClass());
            Object[] values = this.getArgumentValues();
            method.invoke(object, values);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof WriteOnReadError) {
                throw (WriteOnReadError)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Method getSetter(Class type) throws NoSuchMethodException {
        return type.getMethod(this.getSetterName(), this.getArgumentTypes());
    }

    public Object[] getArgumentValues() {
        Object[] values = new Object[this.slots.size()];
        int i = 0;
        for (MetaSlot slot : this.slots) {
            values[i++] = slot.getObject();
        }
        return values;
    }

    public Class[] getArgumentTypes() {
        return this.types.toArray(new Class[0]);
    }
}

