/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.layouts;

import java.util.ArrayList;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;

public abstract class Layout {
    private static final Logger logger = LoggerFactory.getLogger(Layout.class);
    private String classes;
    private String style;
    private String title;
    private boolean requiredMessageShown;
    private boolean optionalMarkShown;
    private static final String REQUIRED_EXPLANATION_CLASS = "requiredMessage";

    public boolean isRequiredMessageShown() {
        return this.requiredMessageShown;
    }

    public void setRequiredMessageShown(boolean requiredMessageShown) {
        this.requiredMessageShown = requiredMessageShown;
    }

    public boolean isOptionalMarkShown() {
        return this.optionalMarkShown;
    }

    public void setOptionalMarkShown(boolean optionalMarkShown) {
        this.optionalMarkShown = optionalMarkShown;
    }

    public void setClasses(String classes) {
        this.classes = classes;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getClasses() {
        return this.classes;
    }

    public String getStyle() {
        return this.style;
    }

    public String getTitle() {
        return this.title;
    }

    public String[] getAndVerifyPropertyNames() {
        String[] names = this.getPropertyNames();
        ArrayList<String> finalNames = new ArrayList<String>();
        for (String name2 : names) {
            String name = name2;
            if (!PropertyUtils.isWriteable((Object)this, (String)name)) {
                logger.warn("Layout {} specified a non-writeable property: {}", (Object)this, (Object)name);
                continue;
            }
            finalNames.add(name);
        }
        return finalNames.toArray(new String[0]);
    }

    public String[] getPropertyNames() {
        return new String[]{"classes", "style", "title", "requiredMessageShown", "optionalMarkShown"};
    }

    protected String[] mergePropertyNames(String[] parentNames, String[] ownNames) {
        String[] allNames = new String[parentNames.length + ownNames.length];
        for (int i = 0; i < allNames.length; ++i) {
            allNames[i] = i < parentNames.length ? parentNames[i] : ownNames[i - parentNames.length];
        }
        return allNames;
    }

    public HtmlComponent createLayout(Object object, Class type) {
        HtmlComponent component = this.createComponent(object, type);
        this.applyStyle(component);
        return component;
    }

    public abstract HtmlComponent createComponent(Object var1, Class var2);

    public void applyStyle(HtmlComponent component) {
        if (this.getClasses() != null) {
            component.setClasses(this.getClasses());
        }
        component.setStyle(this.getStyle());
        component.setTitle(this.getTitle());
    }
}

