/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.contexts;

import org.fenixedu.bennu.core.domain.User;
import pt.ist.fenixWebFramework.renderers.components.HtmlForm;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.components.state.ViewStateWrapper;
import pt.ist.fenixWebFramework.renderers.contexts.PresentationContext;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectKey;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixWebFramework.renderers.utils.RenderMode;

public final class InputContext
extends PresentationContext {
    private HtmlForm form;
    private boolean toolkitRequired = false;

    public InputContext() {
        this.setRenderMode(RenderMode.INPUT);
    }

    protected InputContext(InputContext parent) {
        super(parent);
    }

    @Override
    public IViewState getViewState() {
        IViewState viewState = super.getViewState();
        if (this.getMetaObject() instanceof MetaSlot) {
            MetaObjectKey key = this.getMetaObject().getKey();
            if (key != null) {
                String prefix = key.toString();
                if (viewState instanceof ViewStateWrapper) {
                    ViewStateWrapper wrapper = (ViewStateWrapper)viewState;
                    if (prefix.equals(wrapper.getPrefix())) {
                        return wrapper;
                    }
                    return new ViewStateWrapper(viewState, prefix);
                }
                return new ViewStateWrapper(viewState, prefix);
            }
            return viewState;
        }
        return viewState;
    }

    protected User getUser() {
        return this.getViewState().getUser();
    }

    public HtmlForm getForm() {
        if (this.getParentContext() == null || !(this.getParentContext() instanceof InputContext)) {
            if (this.form == null) {
                this.form = new HtmlForm();
            }
            return this.form;
        }
        return ((InputContext)this.getParentContext()).getForm();
    }

    @Override
    public InputContext createSubContext(MetaObject metaObject) {
        InputContext context = new InputContext(this);
        context.setLayout(this.getLayout());
        context.setMetaObject(metaObject);
        context.setProperties(metaObject.getProperties());
        context.setRenderMode(this.getRenderMode());
        return context;
    }

    public void requireToolkit() {
        if (this.getParentContext() == null || !(this.getParentContext() instanceof InputContext)) {
            this.toolkitRequired = true;
        } else {
            ((InputContext)this.getParentContext()).requireToolkit();
        }
    }

    public boolean isToolkitRequired() {
        return this.toolkitRequired;
    }
}

