/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.components.tags;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.jsp.PageContext;
import pt.ist.fenixWebFramework.renderers.components.tags.HtmlTag;

public class HtmlIncludeTag
extends HtmlTag {
    private PageContext context;
    private String template;
    private Map<String, Object> savedValues;
    private Map<String, Object> usedAttributes;

    public HtmlIncludeTag(PageContext context, String template, Map<String, Object> attributes) {
        super(null);
        this.context = context;
        this.template = template;
        this.usedAttributes = attributes;
        this.savedValues = new HashMap<String, Object>();
    }

    private void pushAttributes() {
        if (this.usedAttributes == null) {
            return;
        }
        for (String name : this.usedAttributes.keySet()) {
            Object value = this.context.getAttribute(name, 2);
            this.savedValues.put(name, value);
            this.context.setAttribute(name, this.usedAttributes.get(name), 2);
        }
    }

    private void popAttributes() {
        if (this.usedAttributes == null) {
            return;
        }
        for (String name : this.savedValues.keySet()) {
            this.context.setAttribute(name, this.savedValues.get(name), 2);
        }
    }

    @Override
    public void writeTag(Writer writer, String indent) throws IOException {
        this.pushAttributes();
        try {
            this.context.getOut().flush();
            this.context.include(this.template);
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
        this.popAttributes();
    }
}

