/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.components;

import javax.servlet.jsp.PageContext;
import org.apache.commons.beanutils.ConvertUtils;
import pt.ist.fenixWebFramework.renderers.components.HtmlFormComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.tags.HtmlTag;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;

public abstract class HtmlSimpleValueComponent
extends HtmlFormComponent {
    private String value;

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String[] getValues() {
        if (this.getValue() == null) {
            return null;
        }
        return new String[]{this.getValue()};
    }

    @Override
    public Object getConvertedValue() {
        if (this.hasConverter()) {
            return this.getConverter().convert(Object.class, this.getValue());
        }
        return ConvertUtils.convert((String)this.getValue(), Object.class);
    }

    @Override
    public Object getConvertedValue(MetaSlot slot) {
        if (this.hasConverter()) {
            return this.getConverter().convert(slot.getStaticType(), this.getValue());
        }
        if (slot.hasConverter()) {
            try {
                return slot.getConverter().newInstance().convert(slot.getStaticType(), this.getValue());
            }
            catch (Exception e) {
                throw new RuntimeException("converter specified in meta slot generated an exception: " + e, e);
            }
        }
        if (this.getValue() == null) {
            return null;
        }
        return ConvertUtils.convert((String)this.getValue(), (Class)slot.getStaticType());
    }

    @Override
    public HtmlTag getOwnTag(PageContext context) {
        HtmlTag tag = super.getOwnTag(context);
        tag.setAttribute("value", HtmlText.escape(this.value));
        return tag;
    }
}

