/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.components;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.PageContext;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlMenuEntry;
import pt.ist.fenixWebFramework.renderers.components.HtmlMenuOption;
import pt.ist.fenixWebFramework.renderers.components.HtmlMultipleValueComponent;
import pt.ist.fenixWebFramework.renderers.components.tags.HtmlTag;

public class HtmlSelectList
extends HtmlMultipleValueComponent {
    private Integer size;
    private Integer tabIndex;
    private List<HtmlMenuOption> options = new ArrayList<HtmlMenuOption>();

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Integer getTabIndex() {
        return this.tabIndex;
    }

    public void setTabIndex(Integer tabIndex) {
        this.tabIndex = tabIndex;
    }

    public HtmlMenuOption createOption(String text) {
        HtmlMenuOption option = new HtmlMenuOption(text);
        this.options.add(option);
        return option;
    }

    @Override
    public void setValues(String ... values) {
        super.setValues(values);
        for (String value : values) {
            for (HtmlMenuOption option : this.getOptions()) {
                if (!option.getValue().equals(value)) continue;
                option.setSelected(true);
            }
        }
    }

    public List<HtmlMenuOption> getOptions() {
        return this.options;
    }

    @Override
    public HtmlTag getOwnTag(PageContext context) {
        HtmlTag tag = super.getOwnTag(context);
        tag.setName("select");
        tag.setAttribute("size", this.getSize());
        tag.setAttribute("multiple", true);
        tag.setAttribute("tabindex", this.getTabIndex());
        if (this.isDisabled()) {
            tag.setAttribute("disabled", true);
        }
        for (HtmlMenuEntry htmlMenuEntry : this.getOptions()) {
            tag.addChild(htmlMenuEntry.getOwnTag(context));
        }
        return tag;
    }

    @Override
    public List<HtmlComponent> getChildren() {
        List<HtmlComponent> children = super.getChildren();
        children.addAll(this.getOptions());
        return children;
    }
}

