/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.components;

import javax.servlet.jsp.PageContext;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlMenuEntry;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.tags.HtmlTag;

public class HtmlMenuOption
extends HtmlMenuEntry {
    private boolean selected;
    private String value;
    private String text;
    private HtmlComponent body;

    public HtmlMenuOption() {
        super(null, false);
    }

    public HtmlMenuOption(String text) {
        super(null, false);
        this.text = text;
    }

    public HtmlMenuOption(String text, String value) {
        this(text);
        this.value = value;
    }

    public HtmlMenuOption(HtmlComponent body) {
        super(null, false);
        this.body = body;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public void setSelected(String value) {
        this.setSelected(this.getValue() != null && this.getValue().equals(value));
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public HtmlComponent getBody() {
        return this.body;
    }

    public void setBody(HtmlComponent body) {
        this.body = body;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public HtmlTag getOwnTag(PageContext context) {
        HtmlTag tag = super.getOwnTag(context);
        tag.setName("option");
        if (this.getText() != null) {
            tag.setText(this.getText());
        }
        if (this.isSelected()) {
            tag.setAttribute("selected", "selected");
        }
        tag.setAttribute("value", HtmlText.escape(this.getValue() == null ? this.getText() : this.getValue()));
        if (this.getBody() != null) {
            tag.addChild(this.getBody().getOwnTag(context));
        }
        return tag;
    }
}

