/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.components;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.PageContext;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlListItem;
import pt.ist.fenixWebFramework.renderers.components.tags.HtmlTag;

public class HtmlList
extends HtmlComponent {
    private List<HtmlListItem> items = new ArrayList<HtmlListItem>();
    private boolean ordered = false;

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public HtmlListItem createItem() {
        HtmlListItem newItem = new HtmlListItem();
        this.items.add(newItem);
        return newItem;
    }

    public HtmlListItem createItem(int index) {
        HtmlListItem newItem = new HtmlListItem();
        this.items.add(index, newItem);
        return newItem;
    }

    @Override
    public List<HtmlComponent> getChildren() {
        ArrayList<HtmlComponent> children = new ArrayList<HtmlComponent>(super.getChildren());
        children.addAll(this.items);
        return children;
    }

    public List<HtmlListItem> getItems() {
        return this.items;
    }

    @Override
    public HtmlTag getOwnTag(PageContext context) {
        HtmlTag tag = super.getOwnTag(context);
        tag.setName(this.isOrdered() ? "ol" : "ul");
        for (HtmlListItem item : this.items) {
            tag.addChild(item.getOwnTag(context));
        }
        return tag;
    }
}

