/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.components;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.PageContext;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.tags.HtmlTag;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class HtmlLink
extends HtmlComponent {
    private String text;
    private String target;
    private String url;
    private String module;
    private String anchor;
    private String contentType;
    private String charSet;
    private boolean moduleRelative;
    private boolean contextRelative;
    private boolean escapeAmpersand;
    private HtmlComponent body;
    private Map<String, String[]> parameters = new Hashtable<String, String[]>();

    public HtmlLink() {
        this.setModuleRelative(true);
        this.setEscapeAmpersand(true);
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        String realUrl = null;
        if (url != null) {
            int indexOfQuestion = url.indexOf(63);
            int indexOfAnchor = url.indexOf(35);
            if (indexOfAnchor != -1) {
                this.setAnchor(url.substring(indexOfAnchor + 1));
            }
            if (indexOfQuestion != -1) {
                realUrl = url.substring(0, indexOfQuestion);
                if (indexOfQuestion < url.length()) {
                    String[] parameresParts;
                    String parameters = indexOfAnchor != -1 ? url.substring(indexOfQuestion + 1, indexOfAnchor) : url.substring(indexOfQuestion + 1);
                    for (String part : parameresParts = this.getParameters(parameters)) {
                        int equalPos = part.indexOf(61);
                        if (equalPos == -1) {
                            this.addParameter(part, "");
                            continue;
                        }
                        String name = part.substring(0, equalPos);
                        String value = part.length() == equalPos + 1 ? "" : part.substring(equalPos + 1);
                        this.addParameter(name, value);
                    }
                }
            }
        }
        this.url = HtmlText.escape(realUrl != null ? realUrl : url);
    }

    private String[] getParameters(String parameters) {
        String[] parameresParts = parameters.split("&amp;");
        if (parameresParts.length < 2) {
            parameresParts = parameters.split("&");
        }
        return parameresParts;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getParameter(String name) {
        String[] values = this.parameters.get(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public String[] getParameterValues(String name) {
        String[] values = this.parameters.get(name);
        return values == null ? new String[]{} : values;
    }

    public void setParameter(String name, String value) {
        this.setParameter(name, new String[]{value});
    }

    public void setParameter(String name, Object value) {
        if (value != null) {
            this.setParameter(name, value.toString());
        }
    }

    public void setParameter(String name, String[] value) {
        this.parameters.put(name, value);
    }

    public void addParameter(String name, Object value) {
        String[] values = this.parameters.get(name);
        if (values == null) {
            this.setParameter(name, value);
        } else if (value != null) {
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[values.length] = value.toString();
            this.setParameter(name, newValues);
        }
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public HtmlComponent getBody() {
        return this.body;
    }

    public void setBody(HtmlComponent body) {
        this.body = body;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isContextRelative() {
        return this.contextRelative;
    }

    public void setContextRelative(boolean contextRelative) {
        this.contextRelative = contextRelative;
        if (!contextRelative) {
            this.setModuleRelative(false);
        }
    }

    public boolean isModuleRelative() {
        return this.moduleRelative;
    }

    public void setModuleRelative(boolean moduleRelative) {
        this.moduleRelative = moduleRelative;
        if (moduleRelative) {
            this.setContextRelative(true);
        }
    }

    public boolean isEscapeAmpersand() {
        return this.escapeAmpersand;
    }

    public void setEscapeAmpersand(boolean escapeAmpersand) {
        this.escapeAmpersand = escapeAmpersand;
    }

    @Override
    public List<HtmlComponent> getChildren() {
        ArrayList<HtmlComponent> children = new ArrayList<HtmlComponent>(super.getChildren());
        if (this.getBody() != null) {
            children.add(this.getBody());
        }
        return children;
    }

    @Override
    public HtmlTag getOwnTag(PageContext context) {
        HtmlTag tag = super.getOwnTag(context);
        tag.setName("a");
        tag.setAttribute("href", this.calculateUrl());
        tag.setAttribute("charset", this.getCharSet());
        tag.setAttribute("type", this.getContentType());
        tag.setAttribute("target", this.getTarget());
        if (this.getText() != null) {
            tag.addChild(new HtmlTag(null, this.getText()));
        }
        if (this.getBody() != null) {
            tag.addChild(this.getBody().getOwnTag(context));
        }
        return tag;
    }

    public String calculateUrl() {
        StringBuilder buffer = new StringBuilder();
        if (this.getModule() != null) {
            buffer.append(RenderUtils.getContextRelativePath(this.getModule()));
        } else if (this.isModuleRelative()) {
            buffer.append(RenderUtils.getModuleRelativePath(""));
        } else if (this.isContextRelative()) {
            buffer.append(RenderUtils.getContextRelativePath(""));
        }
        if (this.getUrl() != null) {
            buffer.append(this.getUrl());
            if (!this.getParameters().isEmpty()) {
                if (this.getUrl().indexOf(63) == -1) {
                    buffer.append("?");
                } else {
                    buffer.append(this.getParametersSeparator());
                }
                Set<String> keys = this.getParameters().keySet();
                int count = keys.size();
                for (String key : keys) {
                    String[] values = this.getParameters().get(key);
                    for (int i = 0; i < values.length; ++i) {
                        if (i > 0) {
                            buffer.append(this.getParametersSeparator());
                        }
                        buffer.append(key);
                        if (values[i] == null || values[i].length() <= 0) continue;
                        buffer.append("=");
                        buffer.append(values[i]);
                    }
                    if (--count <= 0) continue;
                    buffer.append(this.getParametersSeparator());
                }
            }
        }
        if (this.getAnchor() != null) {
            buffer.append("#");
            buffer.append(this.getAnchor());
        }
        if (buffer.length() == 0) {
            buffer.append("#");
        }
        return buffer.toString();
    }

    private String getParametersSeparator() {
        return this.isEscapeAmpersand() ? "&amp;" : "&";
    }

    public static final class Target {
        public static final String BLANK = "_blank";
        public static final String SELF = "_self";
        public static final String PARENT = "_parent";
        public static final String TOP = "_top";
    }
}

