/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.components;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.jsp.PageContext;
import pt.ist.fenixWebFramework.renderers.components.tags.HtmlTag;

public abstract class HtmlComponent
implements Serializable {
    private boolean visible = true;
    private boolean indented = true;
    private String id;
    private String classes;
    private String style;
    private String title;
    private String language;
    private TextDirection direction;
    private String onClick;
    private String onDblClick;
    private String onMouseDown;
    private String onMouseUp;
    private String onMouseOver;
    private String onMouseMove;
    private String onMouseOut;
    private String onKeyPress;
    private String onKeyDown;
    private String onKeyUp;
    private final Map<String, String> custom = new HashMap<String, String>();
    private static Pattern ACCEPTABLE_ID_START_CHAR = Pattern.compile("[A-Za-z]");
    private static Pattern ACCEPTABLE_ID_CHAR = Pattern.compile("[A-Za-z0-9_:.-]");

    public String getClasses() {
        return this.classes;
    }

    public void addClass(String newClass) {
        this.classes = this.classes == null ? newClass : this.classes + " " + newClass;
    }

    public void setClasses(String classes) {
        this.classes = classes;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = HtmlComponent.getValidIdOrName(id);
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public TextDirection getDirection() {
        return this.direction;
    }

    public void setDirection(TextDirection direction) {
        this.direction = direction;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isIndented() {
        return this.indented;
    }

    public void setIndented(boolean idented) {
        this.indented = idented;
    }

    public String getOnClick() {
        return this.onClick;
    }

    public void setOnClick(String onclick) {
        this.onClick = onclick;
    }

    public String getOnDblClick() {
        return this.onDblClick;
    }

    public void setOnDblClick(String ondblclick) {
        this.onDblClick = ondblclick;
    }

    public String getOnKeyDown() {
        return this.onKeyDown;
    }

    public void setOnKeyDown(String onkeydown) {
        this.onKeyDown = onkeydown;
    }

    public String getOnKeyPress() {
        return this.onKeyPress;
    }

    public void setOnKeyPress(String onkeypress) {
        this.onKeyPress = onkeypress;
    }

    public String getOnKeyUp() {
        return this.onKeyUp;
    }

    public void setOnKeyUp(String onkeyup) {
        this.onKeyUp = onkeyup;
    }

    public String getOnMouseDown() {
        return this.onMouseDown;
    }

    public void setOnMouseDown(String onmousedown) {
        this.onMouseDown = onmousedown;
    }

    public String getOnMouseMove() {
        return this.onMouseMove;
    }

    public void setOnMouseMove(String onmousemove) {
        this.onMouseMove = onmousemove;
    }

    public String getOnMouseOut() {
        return this.onMouseOut;
    }

    public void setOnMouseOut(String onmouseout) {
        this.onMouseOut = onmouseout;
    }

    public String getOnMouseOver() {
        return this.onMouseOver;
    }

    public void setOnMouseOver(String onmouseover) {
        this.onMouseOver = onmouseover;
    }

    public String getOnMouseUp() {
        return this.onMouseUp;
    }

    public void setOnMouseUp(String onmouseup) {
        this.onMouseUp = onmouseup;
    }

    public String getAttribute(String name) {
        return this.custom.get(name);
    }

    public void setAttribute(String name, String value) {
        this.custom.put(name, value);
    }

    public List<HtmlComponent> getChildren() {
        return new ArrayList<HtmlComponent>();
    }

    public void draw(Writer writer) throws IOException {
        HtmlTag tag = this.getOwnTag(null);
        tag.writeTag(writer);
    }

    public void draw(PageContext context) throws IOException {
        HtmlTag tag = this.getOwnTag(context);
        tag.writeTag(context);
    }

    public HtmlTag getOwnTag(PageContext context) {
        HtmlTag tag = new HtmlTag("div");
        tag.setAttribute("id", this.getId());
        tag.setAttribute("class", this.getClasses());
        tag.setAttribute("style", this.getStyle());
        tag.setAttribute("title", this.getTitle());
        tag.setAttribute("lang", this.getLanguage());
        if (this.getDirection() != null) {
            tag.setAttribute("dir", this.getDirection().toString());
        }
        tag.setAttribute("onclick", this.getOnClick());
        tag.setAttribute("ondblclick", this.getOnDblClick());
        tag.setAttribute("onmousedown", this.getOnMouseDown());
        tag.setAttribute("onmouseup", this.getOnMouseUp());
        tag.setAttribute("onmouseover", this.getOnMouseOver());
        tag.setAttribute("onmousemove", this.getOnMouseMove());
        tag.setAttribute("onmouseout", this.getOnMouseOut());
        tag.setAttribute("onkeypress", this.getOnKeyPress());
        tag.setAttribute("onkeydown", this.getOnKeyDown());
        tag.setAttribute("onkeyup", this.getOnKeyUp());
        tag.setVisible(this.isVisible());
        tag.setIndented(this.isIndented());
        for (Map.Entry<String, String> entry : this.custom.entrySet()) {
            tag.setAttribute(entry.getKey(), entry.getValue());
        }
        return tag;
    }

    public HtmlComponent getChild(Predicate<HtmlComponent> predicate) {
        for (HtmlComponent child : this.getChildren()) {
            if (predicate.apply((Object)child)) {
                return child;
            }
            HtmlComponent foundComponent = child.getChild(predicate);
            if (foundComponent == null) continue;
            return foundComponent;
        }
        return null;
    }

    public List<HtmlComponent> getChildren(Predicate<HtmlComponent> predicate) {
        ArrayList<HtmlComponent> results = new ArrayList<HtmlComponent>();
        for (HtmlComponent child : this.getChildren()) {
            if (predicate.apply((Object)child)) {
                results.add(child);
            }
            results.addAll(child.getChildren(predicate));
        }
        return results;
    }

    public HtmlComponent getChildWithId(final String id) {
        return this.getChild(new Predicate<HtmlComponent>(){

            public boolean apply(HtmlComponent component) {
                return component.getId().equals(id);
            }
        });
    }

    public static HtmlComponent getComponent(HtmlComponent component, Predicate<HtmlComponent> predicate) {
        if (component == null) {
            return null;
        }
        if (predicate.apply((Object)component)) {
            return component;
        }
        return component.getChild(predicate);
    }

    public static List<HtmlComponent> getComponents(HtmlComponent component, Predicate<HtmlComponent> predicate) {
        if (component == null) {
            return new ArrayList<HtmlComponent>();
        }
        if (predicate.apply((Object)component)) {
            ArrayList<HtmlComponent> results = new ArrayList<HtmlComponent>();
            results.add(component);
            return results;
        }
        return component.getChildren(predicate);
    }

    public static String getValidIdOrName(String desired) {
        if (desired == null) {
            return null;
        }
        StringBuilder name = new StringBuilder();
        int position = 0;
        char[] cArray = desired.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (position == 0 && !ACCEPTABLE_ID_START_CHAR.matcher(c.toString()).matches()) {
                name.append("i");
            }
            if (ACCEPTABLE_ID_CHAR.matcher(c.toString()).matches()) {
                name.append(c);
            } else {
                name.append('_');
            }
            ++position;
        }
        return name.toString();
    }

    public static enum TextDirection {
        RIGTH_TO_LEFT,
        LEFT_TO_RIGHT;


        public String toString() {
            if (this == RIGTH_TO_LEFT) {
                return "rtl";
            }
            return "ltr";
        }
    }
}

