/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import java.util.List;
import pt.ist.fenixWebFramework.renderers.TabularOptionInputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlCheckBox;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlHiddenField;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlSimpleValueComponent;
import pt.ist.fenixWebFramework.renderers.components.controllers.HtmlController;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.components.state.ViewDestination;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;

public class TabularOptionInputRendererWithPostBack
extends TabularOptionInputRenderer {
    private String destination;

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    @Override
    protected HtmlComponent renderComponent(Layout layout, Object object, Class type) {
        HtmlComponent component = super.renderComponent(layout, object, type);
        TabularOptionInputRenderer.CheckableTabularLayout checkableLayout = (TabularOptionInputRenderer.CheckableTabularLayout)layout;
        List<HtmlCheckBox> checkboxes = checkableLayout.getCheckBoxes();
        for (HtmlCheckBox checkbox : checkboxes) {
            checkbox.setOnClick("this.form.postback.value=1; this.form.submit();");
        }
        HtmlInlineContainer htmlInlineContainer = new HtmlInlineContainer();
        HtmlHiddenField hiddenField = new HtmlHiddenField();
        hiddenField.setName("postback");
        htmlInlineContainer.addChild(hiddenField);
        htmlInlineContainer.addChild(component);
        hiddenField.setController(new PostBackController(this.getDestination()));
        return htmlInlineContainer;
    }

    private static class PostBackController
    extends HtmlController {
        private final String destination;

        public PostBackController(String destination) {
            this.destination = destination;
        }

        @Override
        public void execute(IViewState viewState) {
            HtmlSimpleValueComponent component = (HtmlSimpleValueComponent)this.getControlledComponent();
            if (component.getValue() != null && component.getValue().length() > 0) {
                String destinationName = this.destination == null ? "postback" : this.destination;
                ViewDestination destination = viewState.getDestination(destinationName);
                if (destination != null) {
                    viewState.setCurrentDestination(destination);
                } else {
                    viewState.setCurrentDestination("postBack");
                }
                viewState.setSkipValidation(true);
            }
            component.setValue(null);
        }
    }
}

