/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import pt.ist.fenixWebFramework.renderers.IntegerInputRenderer;
import pt.ist.fenixWebFramework.renderers.components.converters.ConversionException;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class ShortInputRenderer
extends IntegerInputRenderer {
    @Override
    protected Converter getConverter() {
        return new ShortNumberConverter(this.getBase());
    }

    private class ShortNumberConverter
    extends Converter {
        private int base;

        public ShortNumberConverter(int base) {
            this.base = base;
        }

        public int getBase() {
            return this.base;
        }

        public void setBase(int base) {
            this.base = base;
        }

        @Override
        public Object convert(Class type, Object value) {
            String numberText = ((String)value).trim();
            if (numberText.length() == 0) {
                return null;
            }
            try {
                return Short.parseShort(numberText.trim(), this.getBase());
            }
            catch (NumberFormatException e) {
                throw new ConversionException("renderers.converter.short", (Throwable)e, true, value);
            }
        }
    }
}

