/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import pt.ist.fenixWebFramework.renderers.IntegerInputRenderer;
import pt.ist.fenixWebFramework.renderers.components.converters.ConversionException;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class LongInputRenderer
extends IntegerInputRenderer {
    @Override
    protected Converter getConverter() {
        return new LongNumberConverter(this.getBase());
    }

    private class LongNumberConverter
    extends Converter {
        private int base;

        public LongNumberConverter(int base) {
            this.base = base;
        }

        public int getBase() {
            return this.base;
        }

        public void setBase(int base) {
            this.base = base;
        }

        @Override
        public Object convert(Class type, Object value) {
            String numberText = ((String)value).trim();
            if (numberText.length() == 0) {
                return null;
            }
            try {
                return Long.parseLong(numberText.trim(), this.getBase());
            }
            catch (NumberFormatException e) {
                throw new ConversionException("renderers.converter.long", (Throwable)e, true, value);
            }
        }
    }
}

