/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import pt.ist.fenixWebFramework.rendererExtensions.CssStyler;
import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlList;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.layouts.ListLayout;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.utils.RendererPropertyUtils;

public class ListRenderer
extends OutputRenderer {
    private String eachClasses;
    private String eachStyle;
    private String eachSchema;
    private String eachLayout;
    private boolean ordered = false;
    private String sortBy;
    private String nullLabel;
    private final Map<String, CssStyler> css = new Hashtable<String, CssStyler>();

    public void setEachClasses(String classes) {
        this.eachClasses = classes;
    }

    public String getEachClasses() {
        return this.eachClasses;
    }

    public void setEachStyle(String style) {
        this.eachStyle = style;
    }

    public String getEachStyle() {
        return this.eachStyle;
    }

    public String getEachLayout() {
        return this.eachLayout;
    }

    public void setEachLayout(String eachLayout) {
        this.eachLayout = eachLayout;
    }

    public String getEachSchema() {
        return this.eachSchema;
    }

    public void setEachSchema(String eachSchema) {
        this.eachSchema = eachSchema;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public String getNullLabel() {
        return this.nullLabel;
    }

    public void setNullLabel(String nullLabel) {
        this.nullLabel = nullLabel;
    }

    public CssStyler getCssStyler(String name) {
        CssStyler css = this.css.get(name);
        if (css == null) {
            css = new CssStyler();
            this.css.put(name, css);
        }
        return css;
    }

    public String getUseCssIf(String name) {
        return this.getCssStyler(name).getUseIf();
    }

    public void setUseCssIf(String name, String property) {
        this.getCssStyler(name).setUseIf(property);
    }

    public String getUseCssIfNot(String name) {
        return this.getCssStyler(name).getUseIfNot();
    }

    public void setUseCssIfNot(String name, String property) {
        this.getCssStyler(name).setUseIfNot(property);
    }

    public String getConditionalCss(String name) {
        return this.getCssStyler(name).getStyleClass();
    }

    public void setConditionalCss(String name, String style) {
        this.getCssStyler(name).setStyleClass(style);
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        List sortedCollection = RenderUtils.sortCollectionWithCriteria((Collection)object, this.getSortBy());
        return new ListRendererLayout(sortedCollection);
    }

    class ListRendererLayout
    extends ListLayout {
        private final Iterator iterator;

        public ListRendererLayout(Collection collection) {
            this.iterator = collection == null ? null : collection.iterator();
        }

        @Override
        protected HtmlComponent getContainer() {
            HtmlList list = (HtmlList)super.getContainer();
            list.setOrdered(ListRenderer.this.isOrdered());
            return list;
        }

        @Override
        protected boolean hasMoreComponents() {
            return this.iterator != null && this.iterator.hasNext();
        }

        @Override
        protected HtmlComponent getNextComponent() {
            Object object = this.iterator.next();
            if (ListRenderer.this.getNullLabel() != null && object == null) {
                return new HtmlText(ListRenderer.this.getNullLabel());
            }
            Schema schema = RenderKit.getInstance().findSchema(ListRenderer.this.getEachSchema());
            String layout = ListRenderer.this.getEachLayout();
            HtmlComponent component = ListRenderer.this.renderValue(object, schema, layout);
            this.applyStyles(object, component);
            return component;
        }

        protected void applyStyles(Object object, HtmlComponent component) {
            for (String style : ListRenderer.this.css.keySet()) {
                CssStyler cssStyler = (CssStyler)ListRenderer.this.css.get(style);
                if (cssStyler == null) continue;
                this.applyConditionalClasses(object, component, cssStyler);
            }
        }

        protected void applyConditionalClasses(Object object, HtmlComponent component, CssStyler cssStyler) {
            Boolean useIf = cssStyler.getUseIf() != null && (Boolean)RendererPropertyUtils.getProperty(object, cssStyler.getUseIf(), false) != false;
            Boolean useIfNot = cssStyler.getUseIfNot() != null && (Boolean)RendererPropertyUtils.getProperty(object, cssStyler.getUseIfNot(), false) == false;
            if (useIf.booleanValue() || useIfNot.booleanValue()) {
                component.setClasses(cssStyler.getStyleClass());
            }
        }
    }
}

