/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import java.util.Collection;
import org.apache.commons.beanutils.PropertyUtils;
import pt.ist.fenixWebFramework.renderers.AbstractToolTipRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlList;
import pt.ist.fenixWebFramework.renderers.components.HtmlListItem;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.contexts.OutputContext;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class GenericOutputWithHoverList
extends AbstractToolTipRenderer {
    private String list;
    private String listFormat;
    private String prefix;
    private String prefixClasses;
    private boolean counterEnabled;

    public boolean isCounterEnabled() {
        return this.counterEnabled;
    }

    public void setCounterEnabled(boolean counter) {
        this.counterEnabled = counter;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefixClasses() {
        return this.prefixClasses;
    }

    public void setPrefixClasses(String prefixClasses) {
        this.prefixClasses = prefixClasses;
    }

    public String getList() {
        return this.list;
    }

    public void setList(String list) {
        this.list = list;
    }

    public String getListFormat() {
        return this.listFormat;
    }

    public void setListFormat(String listFormat) {
        this.listFormat = listFormat;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new AbstractToolTipRenderer.ToolTipLayout(){

            @Override
            public HtmlComponent createComponent(Object object, Class type) {
                OutputContext context = GenericOutputWithHoverList.this.getOutputContext();
                context.setLayout(GenericOutputWithHoverList.this.getSubLayout());
                context.setProperties(this.getProperties());
                HtmlComponent component = RenderKit.getInstance().render(context, object, type);
                Collection list = null;
                try {
                    list = (Collection)PropertyUtils.getProperty((Object)this.getTargetObject(object), (String)GenericOutputWithHoverList.this.getList());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (list.isEmpty()) {
                    return component;
                }
                HtmlList htmlList = new HtmlList();
                int i = 1;
                for (Object objectInList : list) {
                    HtmlListItem item = htmlList.createItem();
                    item.addChild(this.getTextToDisplay(objectInList, i++));
                }
                return this.wrapUpCompletion(component, htmlList);
            }

            private HtmlComponent getTextToDisplay(Object objectInList, int index) {
                HtmlInlineContainer inlineContainer = new HtmlInlineContainer();
                inlineContainer.setIndented(false);
                if (GenericOutputWithHoverList.this.getPrefix() != null) {
                    HtmlInlineContainer prefixContainer = new HtmlInlineContainer();
                    prefixContainer.addChild(new HtmlText(GenericOutputWithHoverList.this.isKey() ? RenderUtils.getResourceString(GenericOutputWithHoverList.this.getBundle(), GenericOutputWithHoverList.this.getPrefix()) : GenericOutputWithHoverList.this.getPrefix()));
                    prefixContainer.setClasses(GenericOutputWithHoverList.this.getPrefixClasses());
                    inlineContainer.addChild(prefixContainer);
                }
                if (GenericOutputWithHoverList.this.isCounterEnabled()) {
                    HtmlInlineContainer counterContainer = new HtmlInlineContainer();
                    counterContainer.addChild(new HtmlText(String.valueOf(index)));
                    counterContainer.setClasses(GenericOutputWithHoverList.this.getPrefixClasses());
                    inlineContainer.addChild(counterContainer);
                }
                if (GenericOutputWithHoverList.this.getPrefix() != null | GenericOutputWithHoverList.this.isCounterEnabled()) {
                    inlineContainer.addChild(new HtmlText(": "));
                }
                inlineContainer.addChild(new HtmlText(RenderUtils.getFormattedProperties(GenericOutputWithHoverList.this.getListFormat(), objectInList), GenericOutputWithHoverList.this.isEscape()));
                return inlineContainer;
            }
        };
    }
}

